/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.security;

import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.DevKitConnectorTypeDefinitionDecorator;

public class PassThroughScheme
extends APISecurityScheme {
    private static final String PASS_THROUGH_CONFIG_TEMPLATE_VM = "templates/devkit/PassThroughConfig.vm";

    public PassThroughScheme(List<Parameter> queryParameters, List<Parameter> headers) {
        this.queryParameters = queryParameters;
        this.headers = headers;
        this.initializeConfigParameters();
    }

    @Override
    public String getSchemeName() {
        return "Pass Through";
    }

    @Override
    public String getConfigurationName() {
        return "PassThroughConfig.java";
    }

    @Override
    public String getTemplateLocation() {
        return PASS_THROUGH_CONFIG_TEMPLATE_VM;
    }

    public List<DevKitConnectorTypeDefinitionDecorator> getDecoratedConnectorQueryParameters() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter queryParam : this.queryParameters) {
            builder.add((Object)new DevKitConnectorTypeDefinitionDecorator(queryParam.getName(), queryParam.getTypeDefinition(), "dummy-package"));
        }
        return builder.build();
    }

    public List<DevKitConnectorTypeDefinitionDecorator> getDecoratedConnectorHeaders() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter header : this.headers) {
            builder.add((Object)new DevKitConnectorTypeDefinitionDecorator(header.getName(), header.getTypeDefinition(), "dummy-package"));
        }
        return builder.build();
    }

    @Override
    protected boolean equalProperties(APISecurityScheme scheme) {
        PassThroughScheme other = (PassThroughScheme)scheme;
        return this.compareParameterList(this.queryParameters, other.queryParameters) && this.compareParameterList(this.headers, other.headers);
    }

    @Override
    public void initializeConfigParameters() {
        this.configParameters = new LinkedList();
        this.configParameters.addAll(this.getQueryParameters());
        this.configParameters.addAll(this.getHeaders());
    }

    private boolean compareParameterList(List<Parameter> thisList, List<Parameter> otherList) {
        if (thisList == null) {
            return otherList == null;
        }
        if (thisList.size() != otherList.size()) {
            return false;
        }
        for (Parameter param : thisList) {
            boolean exists = false;
            for (Parameter otherParam : otherList) {
                if (!param.getName().equals(otherParam.getName())) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            return false;
        }
        return true;
    }
}

