/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.strategy;

import java.io.File;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectModelBuilder;
import org.mule.connectivity.restconnect.internal.modelGeneration.strategy.AMFParserGenerationStrategy;
import org.mule.connectivity.restconnect.internal.modelGeneration.strategy.ModelGenerationStrategy;
import org.mule.connectivity.restconnect.internal.modelGeneration.strategy.RAMLParserGenerationStrategy;

public class AnyParserGenerationStrategy
extends ModelGenerationStrategy {
    private static final Logger logger = LogManager.getLogger(AnyParserGenerationStrategy.class);

    public AnyParserGenerationStrategy(SpecFormat format) {
        super(format);
    }

    @Override
    public RestConnectModelBuilder generateAPIModel(File raml, String rootDir) throws GenerationException, ExecutionException, InterruptedException {
        AMFParserGenerationStrategy amfStrategy = new AMFParserGenerationStrategy(this.specFormat);
        RAMLParserGenerationStrategy ramlParserStrategy = new RAMLParserGenerationStrategy(this.specFormat);
        try {
            return amfStrategy.generateAPIModel(raml, rootDir);
        }
        catch (GenerationException ex) {
            logger.error("Could not generate model using AMF. Falling back to RAMLParser", (Throwable)ex);
            return ramlParserStrategy.generateAPIModel(raml, rootDir);
        }
    }
}

