/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;

public class DataWeaveUtils {
    public static String getParametersDW(List<Parameter> parameters, List<Parameter> properties) {
        ArrayList<String> keys = new ArrayList<String>();
        if (parameters != null) {
            for (Parameter param : parameters) {
                keys.add(DataWeaveUtils.getParameterDWExpression(param));
            }
        }
        if (properties != null) {
            for (Parameter prop : properties) {
                keys.add(DataWeaveUtils.getParameterDWExpression(prop, "property_"));
            }
        }
        return String.format("#[ { %s } filterObject $ != null ]", StringUtils.join(keys, (String)","));
    }

    private static String getParameterDWExpression(Parameter parameter) {
        return DataWeaveUtils.getParameterDWExpression(parameter, "");
    }

    private static String getParameterDWExpression(Parameter parameter, String prefix) {
        if (parameter.hasFixedValue()) {
            return String.format("'%s': '" + parameter.getFixedValue() + "'", parameter.getName());
        }
        return String.format("'%s': vars['" + prefix + "%s']", parameter.getName(), ParserUtils.getXmlName(parameter.getName()));
    }
}

