/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.model.HTTPMethod;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.TypeDefinitionFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.predicate.OperationNamePredicate;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.predicate.ParameterNamePredicate;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;
import org.raml.v2.api.model.v10.datamodel.FileTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.declarations.AnnotationRef;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.system.types.AnnotableStringType;

public class RamlParserUtils
extends ParserUtils {
    protected RamlParserUtils() {
    }

    public static String getMethodDescription(Method method) {
        String description = null;
        if (method.description() != null) {
            description = method.description().value();
        } else if (method.resource() != null && method.resource().description() != null) {
            description = method.resource().description().value();
        }
        return StringUtils.trimToNull((String)description);
    }

    public static String getMethodDisplayName(Method method) {
        String displayName = null;
        if (method.displayName() != null && method.displayName().value() != null && !method.displayName().value().equals(method.method())) {
            displayName = method.displayName().value();
        }
        return StringUtils.trimToNull(displayName);
    }

    public static String getCanonicalOperationName(Method method, String friendlyName) {
        String annotatedOperationName = RamlParserUtils.getAnnotatedOperationName(method);
        HTTPMethod httpMethod = HTTPMethod.fromString(method.method());
        return RamlParserUtils.getCanonicalOperationName(httpMethod, method.resource().resourcePath(), friendlyName, annotatedOperationName);
    }

    public static String getAnnotatedOperationName(Method method) {
        AnnotationRef opNameAnnotation;
        List annotations = method.annotations();
        if (annotations != null && !annotations.isEmpty() && (opNameAnnotation = (AnnotationRef)StreamSupport.stream(Iterables.filter((Iterable)annotations, (Predicate)new OperationNamePredicate()).spliterator(), false).findFirst().orElse(null)) != null) {
            return (String)opNameAnnotation.structuredValue().value();
        }
        return null;
    }

    public static String getAnnotatedParameterName(TypeDeclaration typeDeclaration) {
        AnnotationRef parameterNameAnnotation;
        List annotations = typeDeclaration.annotations();
        if (annotations != null && !annotations.isEmpty() && (parameterNameAnnotation = (AnnotationRef)StreamSupport.stream(Iterables.filter((Iterable)annotations, (Predicate)new ParameterNamePredicate()).spliterator(), false).findFirst().orElse(null)) != null) {
            return (String)parameterNameAnnotation.structuredValue().value();
        }
        return null;
    }

    public static List<Parameter> getParameterList(List<TypeDeclaration> typeDeclarationParameters) {
        return RamlParserUtils.getParameterList(typeDeclarationParameters, false);
    }

    public static List<Parameter> getParameterList(List<TypeDeclaration> typeDeclarationParameters, boolean setDefaultMediaTypes) {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        for (TypeDeclaration typeDeclaration : typeDeclarationParameters) {
            if (setDefaultMediaTypes) {
                parameters.add(new Parameter(typeDeclaration.name(), TypeDefinitionFactory.getTypeDefinition(typeDeclaration, RamlParserUtils.getDefaultMediaType(typeDeclaration))));
                continue;
            }
            parameters.add(new Parameter(typeDeclaration.name(), TypeDefinitionFactory.getTypeDefinition(typeDeclaration)));
        }
        return parameters;
    }

    private static String getDefaultMediaType(TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof FileTypeDeclaration) {
            return "application/octet-stream";
        }
        if (TypeDefinitionFactory.typeIsDefinedWithRAML(typeDeclaration)) {
            return "application/json";
        }
        if (TypeDefinitionFactory.typeIsDefinedWithJSONSchema(typeDeclaration)) {
            return "application/json";
        }
        if (TypeDefinitionFactory.typeIsDefinedWithXMLSchema(typeDeclaration)) {
            return "application/xml";
        }
        return "text/plain";
    }

    public static String getValueFromAnnotableString(AnnotableStringType annotableString) {
        return annotableString == null ? null : annotableString.value();
    }

    public static boolean isIgnored(Method method) {
        for (AnnotationRef annotationRef : method.annotations()) {
            if (!"ignored".equals(annotationRef.annotation().name())) continue;
            return true;
        }
        return false;
    }
}

