/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.operation;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.mule.connectivity.restconnect.exception.DuplicatedParameterNameException;
import org.mule.connectivity.restconnect.exception.InvalidSourceException;
import org.mule.connectivity.restconnect.internal.model.HTTPMethod;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;

public class OperationBuilder {
    private Operation operation = new Operation();

    public OperationBuilder withFriendlyName(String friendlyName) {
        this.operation.setFriendlyName(friendlyName);
        return this;
    }

    public OperationBuilder withAnnotatedDisplayName(String annotatedDisplayName) {
        this.operation.setAnnotatedDisplayName(annotatedDisplayName);
        return this;
    }

    public OperationBuilder withCanonicalName(String cannonicalName) {
        this.operation.setCanonicalName(cannonicalName);
        return this;
    }

    public OperationBuilder withDescription(String description) {
        this.operation.setDescription(description);
        return this;
    }

    public OperationBuilder withUri(String uri) {
        this.operation.setUri(uri);
        return this;
    }

    public OperationBuilder withHttpMethod(HTTPMethod method) {
        this.operation.setHttpMethod(method);
        return this;
    }

    public OperationBuilder withUriParams(List<Parameter> uriParams) {
        this.operation.setUriParameters(uriParams);
        return this;
    }

    public OperationBuilder withQueryParams(List<Parameter> queryParams) {
        this.operation.setQueryParameters(queryParams);
        return this;
    }

    public OperationBuilder withHeaders(List<Parameter> headers) {
        this.operation.setHeaders(headers);
        return this;
    }

    public OperationBuilder withInputMetadata(TypeDefinition inputMetadata) {
        this.operation.setInputMetadata(inputMetadata);
        return this;
    }

    public OperationBuilder withOutputMetadata(TypeDefinition outputMetadata) {
        this.operation.setOutputMetadata(outputMetadata);
        return this;
    }

    public OperationBuilder withSecuritySchemes(List<APISecurityScheme> securitySchemes) {
        this.operation.setSecuritySchemes(securitySchemes);
        return this;
    }

    private List<Parameter> buildParameters() throws InvalidSourceException {
        this.validateUniqueParameterNames(this.operation.getQueryParameters(), this.operation.getUriParameters(), this.operation.getHeaders());
        LinkedList<Parameter> allParams = new LinkedList<Parameter>();
        allParams.addAll(this.operation.getQueryParameters());
        allParams.addAll(this.operation.getUriParameters());
        allParams.addAll(this.operation.getHeaders());
        return allParams;
    }

    protected void validateUniqueParameterNames(List<Parameter> ... parameterSources) throws InvalidSourceException {
        ArrayList<String> keys = new ArrayList<String>();
        for (List<Parameter> parameterSource : parameterSources) {
            for (Parameter param : parameterSource) {
                if (keys.stream().anyMatch(str -> str.equals(param.getName()))) {
                    throw new InvalidSourceException("Invalid spec: Duplicated parameter names", new DuplicatedParameterNameException(param.getName(), this.operation.getCanonicalName(), this.operation.getUri()));
                }
                keys.add(param.getName());
            }
        }
    }

    public Operation build() throws InvalidSourceException {
        this.operation.setParameters(this.buildParameters());
        return this.operation;
    }
}

