/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinitionBuilder;
import org.mule.connectivity.restconnect.internal.model.typesource.JsonTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.MultipartTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.TypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.XmlTypeSource;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.PrimitiveMetadataModelFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.predicate.HasBodyPredicate;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.predicate.IsSupportedTypePredicate;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.predicate.OkResponsePredicate;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.util.RamlParserUtils;
import org.raml.v2.api.model.v10.bodies.Response;
import org.raml.v2.api.model.v10.datamodel.AnyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.BooleanTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.FileTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.IntegerTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.JSONTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NumberTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.XMLTypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;

public class TypeDefinitionFactory {
    private static final Predicate<Response> okAndBodyPredicate = Predicates.and((Predicate)new OkResponsePredicate(), (Predicate)new HasBodyPredicate());
    private static final Logger logger = LogManager.getLogger(TypeDefinitionFactory.class);
    private final Method method;

    public TypeDefinitionFactory(Method method) {
        this.method = method;
    }

    public TypeDefinition constructInputMetadata() {
        return this.getTypeDefinitionWithMediaType(this.method.body());
    }

    public TypeDefinition constructOutputMetadata() {
        ArrayList<TypeDeclaration> mediaTypes = new ArrayList<TypeDeclaration>();
        for (Response response : Iterables.filter((Iterable)this.method.responses(), okAndBodyPredicate)) {
            mediaTypes.addAll(Collections2.filter((Collection)response.body(), (Predicate)new IsSupportedTypePredicate()));
        }
        return this.getTypeDefinitionWithMediaType(mediaTypes);
    }

    private TypeDefinition getTypeDefinitionWithMediaType(List<TypeDeclaration> typeDeclarations) {
        Collection<TypeDeclaration> supportedTypeDeclarations = this.getTypeDeclarations(typeDeclarations);
        if (supportedTypeDeclarations == null) {
            return null;
        }
        TypeDeclaration typeDeclaration = supportedTypeDeclarations.iterator().next();
        return TypeDefinitionFactory.getTypeDefinition(typeDeclaration, typeDeclaration.name());
    }

    public static TypeDefinition getTypeDefinition(TypeDeclaration typeDeclaration) {
        return TypeDefinitionFactory.getTypeDefinition(typeDeclaration, null);
    }

    public static TypeDefinition getTypeDefinition(TypeDeclaration typeDeclaration, String mediaType) {
        if ("multipart/form-data".equalsIgnoreCase(mediaType)) {
            ObjectTypeDeclaration objTypeDeclaration;
            if (typeDeclaration instanceof ObjectTypeDeclaration && (objTypeDeclaration = (ObjectTypeDeclaration)typeDeclaration).properties().size() > 0) {
                return TypeDefinitionFactory.buildTypeDefinition(mediaType, typeDeclaration, new MultipartTypeSource(RamlParserUtils.getParameterList(objTypeDeclaration.properties(), true), new XmlTypeSource(objTypeDeclaration.toXmlSchema())));
            }
            return TypeDefinitionFactory.buildTypeDefinition(mediaType, typeDeclaration, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING));
        }
        if (TypeDefinitionFactory.typeIsDefinedWithRAML(typeDeclaration)) {
            return TypeDefinitionFactory.safelyGetTypeDefinitionFromRAMLType(typeDeclaration, mediaType);
        }
        if (TypeDefinitionFactory.typeIsDefinedWithXMLSchema(typeDeclaration)) {
            XMLTypeDeclaration xmlTypeDeclaration = (XMLTypeDeclaration)typeDeclaration;
            XmlTypeSource source = new XmlTypeSource(xmlTypeDeclaration.schemaContent());
            return TypeDefinitionFactory.buildTypeDefinition(mediaType, (TypeDeclaration)xmlTypeDeclaration, source);
        }
        if (TypeDefinitionFactory.typeIsDefinedWithJSONSchema(typeDeclaration)) {
            JSONTypeDeclaration jsonTypeDeclaration = (JSONTypeDeclaration)typeDeclaration;
            JsonTypeSource source = new JsonTypeSource(jsonTypeDeclaration.schemaContent());
            return TypeDefinitionFactory.buildTypeDefinition(mediaType, (TypeDeclaration)jsonTypeDeclaration, source);
        }
        if (TypeDefinitionFactory.typeIsPrimitive(typeDeclaration)) {
            return TypeDefinitionFactory.buildTypeDefinition(mediaType, typeDeclaration, PrimitiveMetadataModelFactory.createPrimitiveMetadataModel(typeDeclaration));
        }
        if (TypeDefinitionFactory.typeDefinitionIsNotProvided(typeDeclaration)) {
            return TypeDefinitionFactory.buildTypeDefinition(mediaType, typeDeclaration, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING));
        }
        logger.warn("Type {} cannot be parsed.", (Object)typeDeclaration.type());
        return null;
    }

    private static TypeDefinition buildTypeDefinition(String mediaType, TypeDeclaration typeDeclaration, TypeSource source) {
        return new TypeDefinitionBuilder(mediaType == null ? null : MediaType.valueOf((String)mediaType), source, typeDeclaration.required(), typeDeclaration instanceof ArrayTypeDeclaration, typeDeclaration instanceof UnionTypeDeclaration).withDescription(typeDeclaration.description() == null ? null : org.apache.commons.lang3.StringUtils.trimToNull((String)typeDeclaration.description().value())).withDefaultValue(TypeDefinitionFactory.getTypeDeclarationDefaultValue(typeDeclaration)).withExample(typeDeclaration.example() == null ? null : typeDeclaration.example().value()).withAnnotatedDisplayName(RamlParserUtils.getAnnotatedParameterName(typeDeclaration)).build();
    }

    private static String getTypeDeclarationDefaultValue(TypeDeclaration typeDeclaration) {
        try {
            String defaultValue = typeDeclaration.defaultValue();
            return StringUtils.isNotBlank((String)defaultValue) ? defaultValue : null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static TypeDefinition safelyGetTypeDefinitionFromRAMLType(TypeDeclaration typeDeclaration, String mediaType) {
        try {
            return TypeDefinitionFactory.buildTypeDefinition(mediaType, typeDeclaration, new JsonTypeSource(typeDeclaration.toJsonSchema()));
        }
        catch (RuntimeException exception) {
            logger.warn("Couldn't generate a type definition for " + typeDeclaration.name(), (Throwable)exception);
            return TypeDefinitionFactory.buildTypeDefinition(mediaType, typeDeclaration, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING));
        }
    }

    private Collection<TypeDeclaration> getTypeDeclarations(List<TypeDeclaration> typeDeclarations) {
        if (typeDeclarations == null) {
            return null;
        }
        Collection supportedTypeDeclarations = Collections2.filter(typeDeclarations, (Predicate)new IsSupportedTypePredicate());
        if (supportedTypeDeclarations.isEmpty()) {
            return null;
        }
        if (supportedTypeDeclarations.size() > 1) {
            logger.warn("Operation {} {} contains more than one media type. Found: {} media types. Will use the first one.", (Object)this.method.resource().resourcePath(), (Object)this.method.method(), (Object)typeDeclarations.size());
        }
        return supportedTypeDeclarations;
    }

    public static boolean typeIsDefinedWithRAML(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof ObjectTypeDeclaration || typeDeclaration instanceof ArrayTypeDeclaration || typeDeclaration instanceof UnionTypeDeclaration;
    }

    public static boolean typeIsDefinedWithXMLSchema(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof XMLTypeDeclaration;
    }

    public static boolean typeIsDefinedWithJSONSchema(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof JSONTypeDeclaration;
    }

    public static boolean typeIsPrimitive(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof BooleanTypeDeclaration || typeDeclaration instanceof DateTimeOnlyTypeDeclaration || typeDeclaration instanceof DateTypeDeclaration || typeDeclaration instanceof DateTimeTypeDeclaration || typeDeclaration instanceof FileTypeDeclaration || typeDeclaration instanceof IntegerTypeDeclaration || typeDeclaration instanceof NumberTypeDeclaration || typeDeclaration instanceof StringTypeDeclaration || typeDeclaration instanceof TimeOnlyTypeDeclaration;
    }

    public static boolean typeDefinitionIsNotProvided(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof AnyTypeDeclaration;
    }
}

