/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.security;

import java.util.HashMap;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.security.BasicAuthScheme;
import org.mule.connectivity.restconnect.internal.model.security.CustomAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.DigestAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2Scheme;
import org.mule.connectivity.restconnect.internal.model.security.PassThroughScheme;
import org.mule.connectivity.restconnect.internal.model.security.UnsecuredScheme;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.SmartConnectorBasicAuthSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.SmartConnectorCustomSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.SmartConnectorDigestSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.SmartConnectorOAuth2SchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.SmartConnectorPassThroughSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.SmartConnectorSecuritySchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.SmartConnectorUnsecuredSchemeDecorator;

public class SmartConnectorSecuritySchemeDecoratorFactory {
    public static SmartConnectorSecuritySchemeDecorator getSecuritySchemeDecorator(APISecurityScheme scheme, HashMap<APISecurityScheme, String> securitySchemesNames) {
        if (scheme instanceof OAuth2Scheme) {
            return new SmartConnectorOAuth2SchemeDecorator(scheme, securitySchemesNames);
        }
        if (scheme instanceof PassThroughScheme) {
            return new SmartConnectorPassThroughSchemeDecorator(scheme, securitySchemesNames);
        }
        if (scheme instanceof CustomAuthenticationScheme) {
            return new SmartConnectorCustomSchemeDecorator(scheme, securitySchemesNames);
        }
        if (scheme instanceof UnsecuredScheme) {
            return new SmartConnectorUnsecuredSchemeDecorator(scheme, securitySchemesNames);
        }
        if (scheme instanceof BasicAuthScheme) {
            return new SmartConnectorBasicAuthSchemeDecorator(scheme, securitySchemesNames);
        }
        if (scheme instanceof DigestAuthenticationScheme) {
            return new SmartConnectorDigestSchemeDecorator(scheme, securitySchemesNames);
        }
        throw new IllegalArgumentException("Auth scheme not supported. Should not reach this place.");
    }
}

