/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.exception.DuplicatedParameterNameException;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.exception.InvalidSourceException;
import org.mule.connectivity.restconnect.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectModelBuilder;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.uri.BaseUri;
import org.mule.connectivity.restconnect.internal.model.uri.BaseUriBuilder;
import org.mule.connectivity.restconnect.internal.modelGeneration.ModelGenerator;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.RamlParserOperationGenerator;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.resourceLoader.RamlParserExchangeDependencyResourceLoader;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.util.RamlOperationMappingUtils;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.util.RamlParserUtils;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.OperationMappingUtils;
import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.loader.CompositeResourceLoader;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.methods.Method;

public class RamlParserModelGenerator
extends ModelGenerator {
    private static final Logger logger = LogManager.getLogger(RamlParserModelGenerator.class);

    public RamlParserModelGenerator(SpecFormat specFormat) {
        super(specFormat);
        if (!specFormat.equals((Object)SpecFormat.RAML)) {
            throw new IllegalArgumentException("RamlParser does not support " + specFormat.getName() + " format");
        }
    }

    @Override
    public RestConnectModelBuilder generateAPIModel(File raml, String rootDir) throws GenerationException {
        Api api = RamlParserModelGenerator.getAPIFromRamlFile(raml, rootDir);
        return RestConnectModelBuilder.createModel().withApiDescription(api.description() != null ? api.description().value() : "").withApiName(api.title() != null ? api.title().value() : "").withBaseUri(RamlParserModelGenerator.buildBaseUri(api)).withOperations(RamlParserModelGenerator.buildOperationsModel(api));
    }

    private static BaseUri buildBaseUri(Api api) {
        String baseUriString = api.baseUri() != null ? api.baseUri().value() : "";
        String versionString = api.version() != null ? api.version().value() : "";
        return BaseUriBuilder.buildBaseUri(baseUriString, versionString);
    }

    private static List<Operation> buildOperationsModel(Api api) throws DuplicatedParameterNameException, UnsupportedSecuritySchemeException {
        List<Method> methods = RamlOperationMappingUtils.getMethods(api);
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (Method method : methods) {
            if (RamlParserUtils.isIgnored(method)) {
                logger.warn("Resource ignored: {} {}", (Object)method.method(), (Object)method.resource().resourcePath());
                continue;
            }
            operations.add(RamlParserOperationGenerator.generateOperation(api, method));
        }
        OperationMappingUtils.disambiguateRepeatedOperations(operations);
        return operations;
    }

    public static Api getAPIFromRamlFile(File raml, String rootDir) {
        RamlModelResult ramlModelResult;
        CompositeResourceLoader custom = new CompositeResourceLoader(new ResourceLoader[]{new DefaultResourceLoader(), new RamlParserExchangeDependencyResourceLoader(rootDir)});
        RamlModelBuilder ramlModelBuilder = new RamlModelBuilder((ResourceLoader)custom);
        try {
            ramlModelResult = ramlModelBuilder.buildApi(raml);
        }
        catch (Exception e) {
            throw new InvalidSourceException("Invalid RAML: Error in RAML Parser: " + e.getMessage() + ".", e);
        }
        if (ramlModelResult.hasErrors()) {
            String ramlErrors = StringUtils.join((Iterable)ramlModelResult.getValidationResults(), (String)", ");
            throw new InvalidSourceException("Invalid RAML: " + ramlErrors + ".");
        }
        if (ramlModelResult.isVersion08()) {
            throw new InvalidSourceException("RAML 0.8 is not supported.");
        }
        if (ramlModelResult.getApiV10() == null) {
            throw new InvalidSourceException("Invalid RAML: the provided source isn't an API definition but a fragment.");
        }
        return ramlModelResult.getApiV10();
    }
}

