/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.connectivity.restconnect.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.restconnect.internal.model.HTTPMethod;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.operation.OperationBuilder;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinitionBuilder;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.TypeDefinitionFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.security.SecuritySchemeFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.util.RamlParserUtils;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class RamlParserOperationGenerator {
    public static Operation generateOperation(Api api, Method method) throws UnsupportedSecuritySchemeException {
        TypeDefinitionFactory typeDefinitionFactory = new TypeDefinitionFactory(method);
        return new OperationBuilder().withFriendlyName(RamlParserUtils.getMethodDisplayName(method)).withAnnotatedDisplayName(RamlParserUtils.getAnnotatedOperationName(method)).withCanonicalName(RamlParserUtils.getCanonicalOperationName(method, RamlParserUtils.getMethodDisplayName(method))).withDescription(RamlParserUtils.getMethodDescription(method)).withHttpMethod(HTTPMethod.fromString(method.method())).withUri(method.resource().resourcePath()).withUriParams(RamlParserOperationGenerator.buildUriParams(method)).withQueryParams(RamlParserOperationGenerator.buildQueryParams(method)).withHeaders(RamlParserOperationGenerator.buildHeaders(method)).withInputMetadata(typeDefinitionFactory.constructInputMetadata()).withOutputMetadata(typeDefinitionFactory.constructOutputMetadata()).withSecuritySchemes(RamlParserOperationGenerator.buildSecuritySchemes(api, method)).build();
    }

    private static List<APISecurityScheme> buildSecuritySchemes(Api api, Method method) throws UnsupportedSecuritySchemeException {
        return SecuritySchemeFactory.getOperationSecuritySchemes(api, method);
    }

    private static List<Parameter> buildQueryParams(Method method) {
        return RamlParserUtils.getParameterList(method.queryParameters());
    }

    private static List<Parameter> buildUriParams(Method method) {
        Resource resource;
        ArrayList<List<Parameter>> lists = new ArrayList<List<Parameter>>();
        List<Parameter> implicitParams = RamlParserOperationGenerator.getImplicitParameterList(resource);
        for (resource = method.resource(); resource != null; resource = resource.parentResource()) {
            lists.add(0, RamlParserUtils.getParameterList(resource.uriParameters()));
        }
        LinkedList<Parameter> finalList = new LinkedList<Parameter>();
        for (List list : lists) {
            finalList.addAll(list);
        }
        for (Parameter parameter : implicitParams) {
            if (!finalList.stream().noneMatch(p -> p.getName().equals(param.getName()))) continue;
            finalList.add(parameter);
        }
        return finalList;
    }

    private static List<Parameter> getImplicitParameterList(Resource resource) {
        LinkedList<Parameter> implicitParams = new LinkedList<Parameter>();
        Pattern pattern = Pattern.compile(".*?\\{([^\\}]*?)\\}");
        Matcher matcher = pattern.matcher(resource.resourcePath());
        while (matcher.find()) {
            String uriParamName = matcher.group(1);
            Parameter param = new Parameter(uriParamName, TypeDefinitionBuilder.buildImplicitUriParamType());
            implicitParams.add(param);
        }
        return implicitParams;
    }

    private static List<Parameter> buildHeaders(Method method) {
        return RamlParserUtils.getParameterList(method.headers());
    }
}

