/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.typesource.MultipartTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.TypeSource;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.SmartConnectorTypeDefinitionDecorator;

public class DataWeaveUtils {
    public static String getParametersDW(List<Parameter> parameters, List<Parameter> properties) {
        ArrayList<String> keys = new ArrayList<String>();
        if (parameters != null) {
            for (Parameter param : parameters) {
                keys.add(DataWeaveUtils.getParameterDWExpression(param));
            }
        }
        if (properties != null) {
            for (Parameter prop : properties) {
                keys.add(DataWeaveUtils.getParameterDWExpression(prop, "property", "_"));
            }
        }
        return String.format("#[ { %s } filterObject $ != null ]", StringUtils.join(keys, (String)","));
    }

    private static String getParameterDWExpression(Parameter parameter) {
        return DataWeaveUtils.getParameterDWExpression(parameter, "", "");
    }

    private static String getParameterDWExpression(Parameter parameter, String prefix, String prefixSeparator) {
        if (parameter.hasFixedValue()) {
            return String.format("'%s': '" + parameter.getFixedValue() + "'", DataWeaveUtils.escapeDataWeave(parameter.getName()));
        }
        String xmlName = ParserUtils.getXmlName(parameter.getName());
        String prefixedName = (StringUtils.isNotBlank((CharSequence)prefix) ? prefix + (xmlName.startsWith(prefixSeparator) ? "" : prefixSeparator) : "") + xmlName;
        return String.format("'%s': vars['%s']", DataWeaveUtils.escapeDataWeave(parameter.getName()), prefixedName);
    }

    private static String escapeDataWeave(String string) {
        return StringEscapeUtils.escapeJava((String)string).replace("$", "\\$");
    }

    private static String getBodyDWExpression(String mediaType, String metadataName) {
        if (mediaType.equals("application/x-www-form-urlencoded")) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("#[output ").append(mediaType).append(System.lineSeparator()).append("fun formUrlEncoded(obj: Object) = obj mapObject {").append(System.lineSeparator()).append("($$) : $ match {").append(System.lineSeparator()).append("case x is Object -> write(x, \"application/json\")").append(System.lineSeparator()).append("case x is Array -> write(x, \"application/json\")").append(System.lineSeparator()).append("else -> $").append(System.lineSeparator()).append("}}").append(System.lineSeparator()).append("---").append(System.lineSeparator()).append("formUrlEncoded(vars['").append(metadataName).append("'])]").append(System.lineSeparator());
            return stringBuilder.toString();
        }
        return String.format("#[output %s --- vars['%s']]%s", mediaType, metadataName, System.lineSeparator());
    }

    public static String getInputPayloadDWExpression(SmartConnectorTypeDefinitionDecorator typeDefinition) {
        TypeSource source = typeDefinition.getTypeDefinition().getSource();
        StringBuilder strBuilder = new StringBuilder();
        if (source instanceof MultipartTypeSource) {
            MultipartTypeSource multiPartSource = (MultipartTypeSource)source;
            strBuilder.append("#[").append(System.lineSeparator());
            strBuilder.append("%dw 2.0").append(System.lineSeparator());
            strBuilder.append("output multipart/form-data").append(System.lineSeparator());
            strBuilder.append("boundary='rc34b21aa'").append(System.lineSeparator());
            strBuilder.append("---").append(System.lineSeparator());
            strBuilder.append("parts : {").append(System.lineSeparator());
            String prefix = "";
            for (Parameter param : multiPartSource.getParts()) {
                strBuilder.append(prefix).append(System.lineSeparator());
                prefix = ",";
                strBuilder.append(DataWeaveUtils.escapeDataWeave(param.getName())).append(" : {").append(System.lineSeparator());
                strBuilder.append("headers : {").append(System.lineSeparator());
                strBuilder.append("\"Content-Type\": \"").append(param.getTypeDefinition().getMediaType()).append("\"").append(System.lineSeparator());
                strBuilder.append("},").append(System.lineSeparator());
                strBuilder.append("content : ").append("vars['").append(typeDefinition.getName()).append("']");
                if (typeDefinition.hasElementName() && StringUtils.isNotEmpty((CharSequence)typeDefinition.getElementName())) {
                    String elementName = typeDefinition.getElementName().replaceAll("\\{.*\\}", "");
                    strBuilder.append("['").append(elementName).append("']");
                }
                strBuilder.append("['").append(param.getName()).append("']");
                strBuilder.append("}");
            }
        } else {
            return DataWeaveUtils.getBodyDWExpression(typeDefinition.getMediaTypeForTransformation(), typeDefinition.getName());
        }
        strBuilder.append("}").append(System.lineSeparator());
        strBuilder.append("]");
        return strBuilder.toString();
    }
}

