/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.uri;

import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.mule.connectivity.restconnect.internal.model.uri.BaseUri;

public class BaseUriBuilder {
    public static final String VERSION_URI_PARAM = "{version}";
    public static final String VERSION_URI_PARAM_REGEX = "\\{version\\}";

    private static String buildBaseUriString(String baseUri, String version) {
        if (baseUri == null) {
            return "";
        }
        if (baseUri.contains(VERSION_URI_PARAM) && StringUtils.isNotBlank((String)version)) {
            return baseUri.replaceAll(VERSION_URI_PARAM_REGEX, version);
        }
        if (baseUri.contains(VERSION_URI_PARAM)) {
            return "";
        }
        return baseUri;
    }

    public static BaseUri buildBaseUri(String baseUri, String version) {
        String baseUriString = BaseUriBuilder.buildBaseUriString(baseUri, version);
        if (StringUtils.isBlank((String)baseUriString)) {
            return null;
        }
        if (baseUriString.endsWith("/")) {
            baseUriString = StringUtils.chop((String)baseUriString);
        }
        try {
            BaseUri uri = new BaseUri(baseUriString);
            if (!uri.isAbsolute()) {
                return null;
            }
            return uri;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

