/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf.util;

import amf.client.model.domain.DomainElement;
import amf.client.model.domain.DomainExtension;
import amf.client.model.domain.EndPoint;
import amf.client.model.domain.Operation;
import amf.client.model.domain.Parameter;
import amf.client.model.domain.ScalarNode;
import amf.client.model.domain.Shape;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.model.HTTPMethod;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.AMFTypeDefinitionFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;

public class AMFParserUtil
extends ParserUtils {
    private static final String RC_PREFIX = "rest-connect.";
    private static final String RC_IGNORE_ANNOTATION = "rest-connect.ignored";
    private static final String RC_PARAMETER_NAME_ANNOTATION = "rest-connect.parameterName";
    private static final String RC_OPERATION_NAME_ANNOTATION = "rest-connect.operationName";

    public static String getMethodDisplayName(Operation operation) {
        String displayName = null;
        if (operation.name().nonEmpty() && !operation.name().value().equalsIgnoreCase(operation.method().value())) {
            displayName = operation.name().value();
        }
        return StringUtils.trimToNull(displayName);
    }

    public static String getCanonicalOperationName(EndPoint endPoint, Operation operation, String friendlyName) {
        String annotatedOperationName = AMFParserUtil.getAnnotatedOperationName(operation);
        HTTPMethod httpMethod = HTTPMethod.fromString(operation.method().value());
        return AMFParserUtil.getCanonicalOperationName(httpMethod, endPoint.path().value(), friendlyName, annotatedOperationName);
    }

    public static String getAnnotatedParameterName(Parameter parameter) {
        String annotatedParameterName = AMFParserUtil.getAnnotationForElement((DomainElement)parameter, RC_PARAMETER_NAME_ANNOTATION);
        if (StringUtils.isNotBlank((CharSequence)annotatedParameterName)) {
            return annotatedParameterName;
        }
        return null;
    }

    public static String getAnnotatedOperationName(Operation operation) {
        String annotatedDisplayName = AMFParserUtil.getAnnotationForElement((DomainElement)operation, RC_OPERATION_NAME_ANNOTATION);
        if (StringUtils.isNotBlank((CharSequence)annotatedDisplayName)) {
            return annotatedDisplayName;
        }
        return null;
    }

    public static String getAnnotationForElement(DomainElement element, String annotationName) {
        Optional<DomainExtension> optionalDomainExtension = element.customDomainProperties().stream().filter(x -> x.name().nonEmpty() && annotationName.equalsIgnoreCase(x.name().value())).findFirst();
        if (!optionalDomainExtension.isPresent()) {
            return null;
        }
        DomainExtension domainExtension = optionalDomainExtension.get();
        return ((ScalarNode)domainExtension.extension()).value();
    }

    public static boolean elementContainsAnnotation(DomainElement element, String annotationName) {
        return element.customDomainProperties().stream().anyMatch(x -> x.name().nonEmpty() && annotationName.equalsIgnoreCase(x.name().value()));
    }

    public static boolean isIgnored(EndPoint endPoint, Operation operation) {
        return AMFParserUtil.elementContainsAnnotation((DomainElement)endPoint, RC_IGNORE_ANNOTATION) || AMFParserUtil.elementContainsAnnotation((DomainElement)operation, RC_IGNORE_ANNOTATION);
    }

    public static List<org.mule.connectivity.restconnect.internal.model.parameter.Parameter> getParameterList(List<Parameter> amfParameters, ParameterType parameterType) {
        LinkedList<org.mule.connectivity.restconnect.internal.model.parameter.Parameter> parameters = new LinkedList<org.mule.connectivity.restconnect.internal.model.parameter.Parameter>();
        for (Parameter amfParameter : amfParameters) {
            parameters.add(new org.mule.connectivity.restconnect.internal.model.parameter.Parameter(amfParameter.name().value(), parameterType, AMFTypeDefinitionFactory.getTypeDefinition(amfParameter)));
        }
        return parameters;
    }

    public static Shape getActualShape(Shape shape) {
        if (shape == null) {
            return null;
        }
        if (shape.isLink() && shape.linkTarget().isPresent()) {
            return AMFParserUtil.getActualShape((Shape)shape.linkTarget().get());
        }
        return shape;
    }
}

