/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration;

import java.io.File;
import java.util.concurrent.ExecutionException;
import org.mule.connectivity.restconnect.api.Parser;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectModelBuilder;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.AMFModelGenerator;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.RamlParserModelGenerator;

public abstract class ModelGenerator {
    protected final SpecFormat specFormat;

    public ModelGenerator(SpecFormat specFormat) {
        this.specFormat = specFormat;
    }

    public abstract RestConnectModelBuilder generateAPIModel(File var1, String var2) throws GenerationException, ExecutionException, InterruptedException;

    public RestConnectModelBuilder generateAPIModel(File raml) throws GenerationException, ExecutionException, InterruptedException {
        return this.generateAPIModel(raml, raml.getParent());
    }

    public static ModelGenerator get(SpecFormat format, Parser parser) {
        if (parser.equals((Object)Parser.RAMLParser)) {
            return new RamlParserModelGenerator(format);
        }
        if (parser.equals((Object)Parser.AMF)) {
            return new AMFModelGenerator(format);
        }
        throw new IllegalArgumentException("Parser not supported");
    }
}

