/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf;

import amf.MessageStyle;
import amf.ProfileName;
import amf.ProfileNames;
import amf.client.AMF;
import amf.client.environment.DefaultEnvironment;
import amf.client.environment.Environment;
import amf.client.model.document.BaseUnit;
import amf.client.model.document.Document;
import amf.client.model.domain.EndPoint;
import amf.client.model.domain.Server;
import amf.client.model.domain.WebApi;
import amf.client.parse.Oas20Parser;
import amf.client.parse.Parser;
import amf.client.parse.Raml10Parser;
import amf.client.resource.ResourceLoader;
import amf.client.validate.ValidationReport;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.exception.InvalidSourceException;
import org.mule.connectivity.restconnect.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectModelBuilder;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.uri.BaseUri;
import org.mule.connectivity.restconnect.internal.model.uri.BaseUriBuilder;
import org.mule.connectivity.restconnect.internal.modelGeneration.ModelGenerator;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.AMFOperationGenerator;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.resourceLoader.AMFExchangeDependencyResourceLoader;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.util.AMFParserUtil;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.OperationMappingUtils;

public class AMFModelGenerator
extends ModelGenerator {
    private static final Logger logger = LogManager.getLogger(AMFModelGenerator.class);
    private static boolean amfInitialized = false;

    public AMFModelGenerator(SpecFormat specFormat) {
        super(specFormat);
    }

    @Override
    public RestConnectModelBuilder generateAPIModel(File raml, String rootDir) throws GenerationException, ExecutionException, InterruptedException {
        AMFModelGenerator.initializeAMF();
        Parser parser = AMFModelGenerator.getParser(this.specFormat, rootDir);
        WebApi webApi = this.getWebApi(parser, raml.toPath());
        Path rootDirPath = new File(rootDir).toPath().toAbsolutePath();
        return RestConnectModelBuilder.createModel().withRootDir(rootDirPath).withApiDescription(webApi.description().nonEmpty() ? webApi.description().value() : "").withApiName(webApi.name().value()).withBaseUri(AMFModelGenerator.buildBaseUri(webApi)).withOperations(AMFModelGenerator.buildOperationsModel(webApi));
    }

    private static void initializeAMF() throws ExecutionException, InterruptedException {
        if (!amfInitialized) {
            AMF.init().get();
            amfInitialized = true;
        }
    }

    private static List<Operation> buildOperationsModel(WebApi webApi) throws UnsupportedSecuritySchemeException {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (EndPoint endPoint : webApi.endPoints()) {
            for (amf.client.model.domain.Operation operation : endPoint.operations()) {
                if (AMFParserUtil.isIgnored(endPoint, operation)) {
                    logger.warn("Resource ignored: {} {}", (Object)operation.method(), (Object)endPoint.path());
                    continue;
                }
                operations.add(AMFOperationGenerator.generateOperation(webApi, endPoint, operation));
            }
        }
        OperationMappingUtils.disambiguateRepeatedOperations(operations);
        return operations;
    }

    private static BaseUri buildBaseUri(WebApi api) {
        String url = "";
        for (Server server : api.servers()) {
            if (!server.url().nonEmpty()) continue;
            url = server.url().value();
            break;
        }
        return BaseUriBuilder.buildBaseUri(url, api.version().value());
    }

    private static Parser getParser(SpecFormat format, String rootDir) {
        Environment env = DefaultEnvironment.apply().add((ResourceLoader)new AMFExchangeDependencyResourceLoader(rootDir));
        if (format.equals((Object)SpecFormat.RAML)) {
            return new Raml10Parser(env);
        }
        if (format.equals((Object)SpecFormat.OAS)) {
            return new Oas20Parser(env);
        }
        throw new IllegalArgumentException("Spec format " + format.getName() + "not supported");
    }

    public WebApi getWebApi(Parser parser, Path path) {
        Document ramlDocument;
        try {
            ramlDocument = AMFModelGenerator.parseFile(parser, "file://" + path.toAbsolutePath().toString());
            AMFModelGenerator.validate(ramlDocument, this.specFormat);
            ramlDocument = AMFModelGenerator.resolve(ramlDocument, this.specFormat);
        }
        catch (Exception e) {
            throw new InvalidSourceException("Invalid Spec: Error in AMF: " + e.getMessage() + ".", e);
        }
        return AMFModelGenerator.getWebApi(ramlDocument);
    }

    private static Document resolve(Document ramlDocument, SpecFormat specFormat) {
        if (specFormat.equals((Object)SpecFormat.RAML)) {
            return (Document)AMF.resolveRaml10((BaseUnit)ramlDocument);
        }
        if (specFormat.equals((Object)SpecFormat.OAS)) {
            return (Document)AMF.resolveOas20((BaseUnit)ramlDocument);
        }
        throw new IllegalArgumentException("Unrecognised spec format");
    }

    private static void validate(Document ramlDocument, SpecFormat specFormat) throws ExecutionException, InterruptedException {
        if (specFormat.equals((Object)SpecFormat.RAML)) {
            ValidationReport report = (ValidationReport)AMF.validate((BaseUnit)ramlDocument, (ProfileName)ProfileNames.RAML(), (MessageStyle)ProfileNames.AMF().messageStyle()).get();
            if (!report.conforms()) {
                throw new InvalidSourceException(report.toString());
            }
        } else if (specFormat.equals((Object)SpecFormat.OAS)) {
            ValidationReport report = (ValidationReport)AMF.validate((BaseUnit)ramlDocument, (ProfileName)ProfileNames.OAS(), (MessageStyle)ProfileNames.AMF().messageStyle()).get();
            if (!report.conforms()) {
                throw new InvalidSourceException(report.toString());
            }
        } else {
            throw new IllegalArgumentException("Unrecognised spec format");
        }
    }

    public static WebApi getWebApi(Document document) {
        return (WebApi)document.encodes();
    }

    public static Document parseFile(Parser parser, String url) {
        return (Document)AMFModelGenerator.handleFuture(parser.parseFileAsync(url));
    }

    private static <T, U> U handleFuture(CompletableFuture<T> f) {
        try {
            return (U)f.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("An error happend while parsing the api. Message: " + e.getMessage(), e);
        }
    }
}

