/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser;

import java.util.ArrayList;
import java.util.List;
import org.mule.connectivity.restconnect.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.restconnect.internal.model.HTTPMethod;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.operation.OperationBuilder;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.RamlParserTypeDefinitionFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.security.RamlParserSecuritySchemeFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.util.RamlParserUtils;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class RamlParserOperationGenerator {
    public static Operation generateOperation(Api api, Method method) throws UnsupportedSecuritySchemeException {
        RamlParserTypeDefinitionFactory typeDefinitionFactory = new RamlParserTypeDefinitionFactory(method);
        return new OperationBuilder().withFriendlyName(RamlParserUtils.getMethodDisplayName(method)).withAnnotatedDisplayName(RamlParserUtils.getAnnotatedOperationName(method)).withCanonicalName(RamlParserUtils.getCanonicalOperationName(method, RamlParserUtils.getMethodDisplayName(method))).withDescription(RamlParserUtils.getMethodDescription(method)).withHttpMethod(HTTPMethod.fromString(method.method())).withUri(method.resource().resourcePath()).withUriParams(RamlParserOperationGenerator.buildUriParams(method)).withQueryParams(RamlParserOperationGenerator.buildQueryParams(method)).withHeaders(RamlParserOperationGenerator.buildHeaders(method)).withInputMetadata(typeDefinitionFactory.constructInputMetadata()).withOutputMetadata(typeDefinitionFactory.constructOutputMetadata()).withSecuritySchemes(RamlParserOperationGenerator.buildSecuritySchemes(api, method)).build();
    }

    private static List<APISecurityScheme> buildSecuritySchemes(Api api, Method method) throws UnsupportedSecuritySchemeException {
        return RamlParserSecuritySchemeFactory.getOperationSecuritySchemes(api, method);
    }

    private static List<Parameter> buildQueryParams(Method method) {
        return RamlParserUtils.getParameterList(method.queryParameters(), ParameterType.QUERY);
    }

    private static List<Parameter> buildUriParams(Method method) {
        ArrayList<Parameter> uriParameters = new ArrayList<Parameter>();
        for (Resource resource = method.resource(); resource != null; resource = resource.parentResource()) {
            for (Parameter uriParam : RamlParserUtils.getParameterList(resource.uriParameters(), ParameterType.URI)) {
                if (!uriParameters.stream().noneMatch(y -> y.getExternalName().equalsIgnoreCase(uriParam.getExternalName()))) continue;
                uriParameters.add(0, uriParam);
            }
        }
        return uriParameters;
    }

    private static List<Parameter> buildHeaders(Method method) {
        return RamlParserUtils.getParameterList(method.headers(), ParameterType.HEADER);
    }
}

