/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit;

import java.util.Map;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.security.BasicAuthScheme;
import org.mule.connectivity.restconnect.internal.model.security.CustomAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.DigestAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2AuthorizationCodeScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2ClientCredentialsScheme;
import org.mule.connectivity.restconnect.internal.model.security.PassThroughScheme;
import org.mule.connectivity.restconnect.internal.model.security.UnsecuredScheme;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitBasicAuthSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitCustomAuthenticationSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitDigestAuthenticationSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitOAuth2AuthorizationCodeSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitOAuth2ClientCredentialsSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitPassThroughSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitSecuritySchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitUnsecuredSchemeSchemeDecorator;

public class DevKitSecuritySchemeDecoratorFactory {
    public static DevKitSecuritySchemeDecorator getSecuritySchemeDecorator(APISecurityScheme scheme, Map<APISecurityScheme, String> securitySchemesNames) {
        if (scheme instanceof OAuth2ClientCredentialsScheme) {
            return new DevKitOAuth2ClientCredentialsSchemeDecorator(scheme, securitySchemesNames);
        }
        if (scheme instanceof OAuth2AuthorizationCodeScheme) {
            return new DevKitOAuth2AuthorizationCodeSchemeDecorator(scheme, securitySchemesNames);
        }
        if (scheme instanceof PassThroughScheme) {
            return new DevKitPassThroughSchemeDecorator(scheme, securitySchemesNames);
        }
        if (scheme instanceof CustomAuthenticationScheme) {
            return new DevKitCustomAuthenticationSchemeDecorator(scheme, securitySchemesNames);
        }
        if (scheme instanceof UnsecuredScheme) {
            return new DevKitUnsecuredSchemeSchemeDecorator(scheme, securitySchemesNames);
        }
        if (scheme instanceof BasicAuthScheme) {
            return new DevKitBasicAuthSchemeDecorator(scheme, securitySchemesNames);
        }
        if (scheme instanceof DigestAuthenticationScheme) {
            return new DevKitDigestAuthenticationSchemeDecorator(scheme, securitySchemesNames);
        }
        throw new IllegalArgumentException("Auth scheme not supported. Should not reach this place.");
    }
}

