package org.mule.connectivity.restconnect.internal.templateEngine.builder;

import org.mule.connectivity.restconnect.internal.templateEngine.SmartConnectorTemplateEngine;


public class SmartConnectorTemplateEngineBuilder extends TemplateEngineBuilder<SmartConnectorTemplateEngineBuilder> {

    private SmartConnectorTemplateEngineBuilder() {

    }

    public static SmartConnectorTemplateEngineBuilder createSmartConnector() {
        return new SmartConnectorTemplateEngineBuilder();
    }

    @Override
    public SmartConnectorTemplateEngineBuilder withGenerateProjectFiles(boolean generateProjectFiles) {
        return this;
    }

    public void execute() throws Exception {
        execute(true);
    }

    public void execute(boolean packageProject) throws Exception {
        SmartConnectorTemplateEngine engine = new SmartConnectorTemplateEngine(this);
        engine.applyTemplates();

        if(packageProject){
            engine.packageProject();
        }
    }

}
