package org.mule.connectivity.restconnect.internal.templateEngine.decorator.type;

import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;

public abstract class TypeDefinitionDecorator {

    protected final TypeDefinition typeDefinition;
    private final String externalName;
    private final String internalName;

    public TypeDefinitionDecorator(String externalName, String internalName, TypeDefinition typeDefinition) {
        this.externalName = externalName;
        this.internalName = internalName;
        this.typeDefinition = typeDefinition;
    }

    public TypeDefinitionDecorator(TypeDefinition typeDefinition) {
        this.externalName = null;
        this.internalName = null;
        this.typeDefinition = typeDefinition;
    }

    public TypeDefinition getTypeDefinition() {
        return typeDefinition;
    }

    public String getExternalName() {
        return externalName;
    }

    public String getInternalName() {
        return internalName;
    }

    public boolean hasMediaType(){
        return this.typeDefinition.getMediaType() != null;
    }

    public String getMediaType() {
        return this.typeDefinition.getMediaType() == null ? null : this.typeDefinition.getMediaType().toString();
    }

    public boolean isRequired() {
        //Default value only works when the value for the parameter is not set
        //A required parameter would always override the default value
        return !this.hasDefaultValue() && this.typeDefinition.isRequired();
    }

    public String getDescription() {
        return this.typeDefinition.getDescription();
    }

    public String getDefaultValue() {
        return this.typeDefinition.getDefaultValue();
    }

    public boolean hasDefaultValue() {
        return this.typeDefinition.getDefaultValue() != null && StringUtils.isNotBlank(this.typeDefinition.getDefaultValue());
    }

    public String getExample() {
        return this.typeDefinition.getExample();
    }

    public boolean isPrimitiveType() {
        return this.typeDefinition.getSource() instanceof PrimitiveTypeSource;
    }

    public boolean isUnionType() {
        return this.typeDefinition.isUnionType();
    }

    public boolean isArrayType() {
        return this.typeDefinition.isArrayType();
    }

    public boolean isEnumType() {
        return this.typeDefinition.isEnum();
    }

    public String getAnnotatedParameterName(){
        return typeDefinition.getAnnotatedDisplayName();
    }

}
