package org.mule.connectivity.restconnect.internal.util;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.MethodDeclaration;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.typesource.MultipartTypeSource;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation.DevKitOperationDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.DevKitConnectorTypeDefinitionDecorator;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

public class JavaRequestUtils {

    public static String buildRequestEntity(DevKitOperationDecorator operation) throws IOException {

        DevKitConnectorTypeDefinitionDecorator type = operation.getDecoratedInputMetadata();

        StringBuilder builder = new StringBuilder();

        if(type.getTypeDefinition().getSource() instanceof MultipartTypeSource){
            MultipartTypeSource source = (MultipartTypeSource)type.getTypeDefinition().getSource();

            builder.append("MultiPart multiPart = new MultiPart()");

            for(Parameter part : source.getParts()){

                String getterMethod = getGetterMethodForAttribute(type, part.getExternalName());

                if(getterMethod != null){
                    builder.append(System.lineSeparator());
                    builder.append(".bodyPart(new BodyPart(entity.").append(getterMethod).append("(), ");
                    builder.append("MediaType.valueOf(\"").append(part.getTypeDefinition().getMediaType()).append("\")))");
                }
            }
            builder.append(";").append(System.lineSeparator());

            builder.append("requestBuilder.entity(multiPart);").append(System.lineSeparator());
        }
        else {
            builder.append("requestBuilder.entity(entity);").append(System.lineSeparator());
        }

        return builder.toString();
    }

    private static String getGetterMethodForAttribute(DevKitConnectorTypeDefinitionDecorator type, String attributeName) throws IOException {
        InputStream stream = new FileInputStream(type.getPojoLocation().toFile());

        CompilationUnit cu;

        try{
            cu = JavaParser.parse(stream);
        }
        finally {
            stream.close();
        }

        Optional<MethodDeclaration> getter = cu.findAll(MethodDeclaration.class).stream()
                .filter(f -> f.isPublic() && !f.isStatic())
                .filter(f -> f.getName().asString().toLowerCase().startsWith("get") && f.getName().asString().toLowerCase().contains(attributeName.toLowerCase()))
                .findFirst();

        return getter.isPresent() ? getter.get().getName().asString() : null;
    }

    public void visit(MethodDeclaration n, Object arg)
    {
        // extract method information here.
        // put in to hashmap
    }


}
