package org.mule.connectivity.restconnect.api;

public enum SpecFormat {

    RAML("RAML"),
    OAS("OAS");

    private String name;

    SpecFormat(String name){
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SpecFormat getFromString(String specName){
        if(specName.equalsIgnoreCase(RAML.name)){
            return RAML;
        }
        else if(specName.equalsIgnoreCase(OAS.name)){
            return OAS;
        }

        throw new IllegalArgumentException("Parser " + specName + " does not exist");
    }

}
