package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser;

import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource.PrimitiveType;
import org.raml.v2.api.model.v10.datamodel.*;

public class PrimitiveMetadataModelFactory {

    // Private constructor to prevent instantiation.
    private PrimitiveMetadataModelFactory() {

    }

    public static PrimitiveTypeSource createPrimitiveMetadataModel(TypeDeclaration typeDeclaration) {
        if(typeDeclaration instanceof BooleanTypeDeclaration) {
            return new PrimitiveTypeSource(PrimitiveType.BOOLEAN);
        }

        else if(typeDeclaration instanceof DateTimeOnlyTypeDeclaration) {
            return new PrimitiveTypeSource(PrimitiveType.DATE_TIME_ONLY);
        }

        else if(typeDeclaration instanceof DateTimeTypeDeclaration) {
            return new PrimitiveTypeSource(PrimitiveType.DATE_TIME);
        }

        else if(typeDeclaration instanceof DateTypeDeclaration) {
            return new PrimitiveTypeSource(PrimitiveType.DATE);
        }

        else if(typeDeclaration instanceof FileTypeDeclaration) {
            return new PrimitiveTypeSource(PrimitiveType.FILE);
        }

        else if(typeDeclaration instanceof IntegerTypeDeclaration) {
            return new PrimitiveTypeSource(PrimitiveType.INTEGER);
        }

        else if(typeDeclaration instanceof NumberTypeDeclaration) {
            return new PrimitiveTypeSource(PrimitiveType.NUMBER);
        }

        else if(typeDeclaration instanceof StringTypeDeclaration) {
            return new PrimitiveTypeSource(PrimitiveType.STRING);
        }

        else if(typeDeclaration instanceof TimeOnlyTypeDeclaration) {
            return new PrimitiveTypeSource(PrimitiveType.TIME_ONLY);
        }

        throw new IllegalArgumentException("Type declaration isn't from a primitive type.");
    }

}
