package org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector;

import org.mule.connectivity.restconnect.internal.model.security.*;

import java.util.HashMap;

public class SmartConnectorSecuritySchemeDecoratorFactory {
    public static SmartConnectorSecuritySchemeDecorator getSecuritySchemeDecorator(APISecurityScheme scheme, HashMap<APISecurityScheme, String> securitySchemesNames){
        if(scheme instanceof OAuth2Scheme){
            return new SmartConnectorOAuth2SchemeDecorator(scheme, securitySchemesNames);
        }
        else if(scheme instanceof PassThroughScheme){
            return new SmartConnectorPassThroughSchemeDecorator(scheme, securitySchemesNames);
        }
        else if(scheme instanceof CustomAuthenticationScheme){
            return new SmartConnectorCustomSchemeDecorator(scheme, securitySchemesNames);
        }
        else if(scheme instanceof UnsecuredScheme){
            return new SmartConnectorUnsecuredSchemeDecorator(scheme, securitySchemesNames);
        }
        else if(scheme instanceof BasicAuthScheme){
            return new SmartConnectorBasicAuthSchemeDecorator(scheme, securitySchemesNames);
        }
        else if(scheme instanceof DigestAuthenticationScheme){
            return new SmartConnectorDigestSchemeDecorator(scheme, securitySchemesNames);
        }
        else {
            throw new IllegalArgumentException("Auth scheme not supported. Should not reach this place.");
        }
    }
}
