package org.mule.connectivity.restconnect.internal.model.parameter;

import org.apache.commons.lang.StringUtils;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;

public class Parameter {
    private String externalName;
    private TypeDefinition typeDefinition;
    private String fixedValue;
    private boolean isPassword;
    private ParameterType parameterType;

    //Indicates if this parameter is duplicated among the full group of parameters this API has.
    //This should only be allowed for parameters of different types (i.e. header & queryParam) in order to disambiguate them
    private boolean duplicatedName;

    public Parameter(String externalName, ParameterType parameterType, TypeDefinition typeDefinition){
        this.externalName = externalName;
        this.typeDefinition = typeDefinition;
        this.parameterType = parameterType;
    }

    public Parameter(String externalName, ParameterType parameterType, TypeDefinition typeDefinition, boolean password){
        this.externalName = externalName;
        this.typeDefinition = typeDefinition;
        this.isPassword = password;
        this.parameterType = parameterType;
    }

    public String getExternalName() {
        return externalName;
    }

    public void setExternalName(String name) {
        this.externalName = name;
    }

    public String getInternalName() {
        if(duplicatedName){
            return parameterType.getName() + externalName;
        }

        return externalName;
    }

    public TypeDefinition getTypeDefinition() {
        return typeDefinition;
    }

    public String getFixedValue() {
        return fixedValue;
    }

    public void setFixedValue(String fixedValue) {
        this.fixedValue = fixedValue;
    }

    public boolean hasFixedValue() {
        return !StringUtils.isBlank(this.fixedValue);
    }

    public boolean isPassword() {
        return isPassword;
    }

    public void setPassword(boolean password) {
        isPassword = password;
    }

    public boolean isDuplicatedName() {
        return duplicatedName;
    }

    public void setDuplicatedName(boolean duplicatedExternalName) {
        this.duplicatedName = duplicatedExternalName;
    }
}
