package org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector;

import com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;

import java.util.List;

public class SmartConnectorSecuritySchemeDecoratorHelper {

    public static String getXmlConfigsString(List<SmartConnectorXMLConfig> xmlConfigs){
        if(xmlConfigs != null && xmlConfigs.size() > 0){
            StringBuilder strBuilder = new StringBuilder();
            for (SmartConnectorXMLConfig xmlConfig : xmlConfigs){
                strBuilder.append(xmlConfig.toString());
                strBuilder.append(System.lineSeparator());
            }
            return strBuilder.toString();
        }
        return "";
    }

    public static String getXmlSchemasString(List<SmartConnectorXMLSchema> xmlSchemas){
        if(xmlSchemas != null && xmlSchemas.size() > 0){
            StringBuilder strBuilder = new StringBuilder();
            for (SmartConnectorXMLSchema xmlSchema : xmlSchemas){
                strBuilder.append(xmlSchema.toString());
                strBuilder.append(System.lineSeparator());
            }
            return strBuilder.toString();
        }
        return "";
    }

    public static String getXmlSchemaLocationsString(List<SmartConnectorXMLSchemaLocation> xmlSchemaLocations){
        if(xmlSchemaLocations != null && xmlSchemaLocations.size() > 0){
            StringBuilder strBuilder = new StringBuilder();
            for (SmartConnectorXMLSchemaLocation xmlSchemaLocation : xmlSchemaLocations){
                strBuilder.append(xmlSchemaLocation.toString());
                strBuilder.append(System.lineSeparator());
            }
            return strBuilder.toString();
        }
        return "";
    }

    public static List<Parameter> buildPrefixedParameters(List<Parameter> parameters, String namePrefix, ParameterType parameterType) {
        ImmutableList.Builder<Parameter> builder = ImmutableList.builder();

        String prefix = StringUtils.isNotBlank(namePrefix) ? namePrefix + "-" : "";
        for (Parameter param : parameters) {
            builder.add(new Parameter( prefix + param.getExternalName(), parameterType, param.getTypeDefinition(), param.isPassword()));
        }

        return builder.build();
    }
}
