/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.api;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.api.ConnectorType;
import org.mule.connectivity.restconnect.api.Parser;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.internal.model.ConnectorCategory;
import org.mule.connectivity.restconnect.internal.model.MavenDependency;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectAPIModel;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectModelBuilder;
import org.mule.connectivity.restconnect.internal.modelGeneration.ModelGenerator;
import org.mule.connectivity.restconnect.internal.templateEngine.builder.DevKitTemplateEngineBuilder;
import org.mule.connectivity.restconnect.internal.templateEngine.builder.SmartConnectorTemplateEngineBuilder;
import org.mule.connectivity.restconnect.internal.templateEngine.builder.TemplateEngineBuilder;

public class RestConnect {
    private File spec;
    private SpecFormat format;
    private Parser parser;
    private ConnectorType connectorType;
    private String apiName;
    private Path outputDir;
    private boolean packageConnector = true;
    private String category;
    private boolean generateProjectFiles = true;
    private String projectDescription;
    private List<MavenDependency> dependencies = new ArrayList<MavenDependency>();
    private String rootDir;
    private ConnectorCategory connectorCategory;
    private String customPackage;
    private String groupId;
    private String artifactId;
    private String version;

    public static RestConnect getInstance() {
        return new RestConnect();
    }

    public RestConnect withApiName(String apiName) {
        this.apiName = apiName;
        return this;
    }

    public RestConnect withOutputDir(Path outputDir) {
        this.outputDir = outputDir;
        return this;
    }

    public RestConnect createConnectorFromSpec(File spec, SpecFormat format, Parser parser, ConnectorType connectorType) {
        this.spec = spec;
        this.format = format;
        this.parser = parser;
        this.connectorType = connectorType;
        return this;
    }

    public void run() throws Exception {
        RestConnectAPIModel model = this.getModel();
        RestConnect.run(model, RestConnect.getTemplateEngine(this.connectorType), this.outputDir, this.generateProjectFiles, this.packageConnector);
    }

    public static void run(RestConnectAPIModel model, TemplateEngineBuilder templateEngine, Path outputDir, boolean generateProjectFiles, boolean packageConnector) throws Exception {
        Object templateEngineBuilder = templateEngine.fromModel(model);
        if (outputDir != null) {
            ((TemplateEngineBuilder)templateEngineBuilder).inOutputDir(outputDir);
        }
        ((TemplateEngineBuilder)templateEngineBuilder).withGenerateProjectFiles(generateProjectFiles);
        ((TemplateEngineBuilder)templateEngineBuilder).execute(packageConnector);
    }

    private ModelGenerator getModelGenerator(Parser parser, SpecFormat format) {
        return ModelGenerator.get(format, parser);
    }

    public static TemplateEngineBuilder getTemplateEngine(ConnectorType connectorType) {
        if (connectorType.equals((Object)ConnectorType.DevKitConnector)) {
            return DevKitTemplateEngineBuilder.createDevKitConnector();
        }
        return SmartConnectorTemplateEngineBuilder.createSmartConnector();
    }

    public RestConnect withPackageConnector(boolean packageConnector) {
        this.packageConnector = packageConnector;
        return this;
    }

    public RestConnect withCategory(String category) {
        this.category = category;
        return this;
    }

    public RestConnect withGenerateProjectFiles(boolean generateProjectFiles) {
        this.generateProjectFiles = generateProjectFiles;
        return this;
    }

    public RestConnect withprojectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
        return this;
    }

    public RestConnect withDependency(MavenDependency dependency) {
        this.dependencies.add(dependency);
        return this;
    }

    public RestConnect withRootDir(String rootDir) {
        this.rootDir = rootDir;
        return this;
    }

    public RestConnect withCategory(ConnectorCategory connectorCategory) {
        this.connectorCategory = connectorCategory;
        return this;
    }

    public RestConnect withCustomPackage(String customPackage) {
        this.customPackage = customPackage;
        return this;
    }

    public RestConnectAPIModel getModel() throws Exception {
        ModelGenerator modelGenerator = ModelGenerator.get(this.format, this.parser);
        RestConnectModelBuilder modelBuilder = StringUtils.isNotBlank((CharSequence)this.rootDir) ? modelGenerator.generateAPIModel(this.spec, this.rootDir) : modelGenerator.generateAPIModel(this.spec);
        if (StringUtils.isNotBlank((CharSequence)this.apiName)) {
            modelBuilder.withApiName(this.apiName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.category)) {
            modelBuilder.withCategory(this.category);
        }
        if (StringUtils.isNotBlank((CharSequence)this.projectDescription)) {
            modelBuilder.withProjectDescription(this.projectDescription);
        }
        if (StringUtils.isNotBlank((CharSequence)this.customPackage)) {
            modelBuilder.withCustomPackage(this.customPackage);
        }
        if (StringUtils.isNotBlank((CharSequence)this.groupId)) {
            modelBuilder.withGroupId(this.groupId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.artifactId)) {
            modelBuilder.withArtifactId(this.artifactId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.version)) {
            modelBuilder.withVersion(this.version);
        }
        if (this.connectorCategory != null) {
            modelBuilder.withCategory(this.connectorCategory);
        }
        for (MavenDependency dependency : this.dependencies) {
            modelBuilder.withDependency(dependency);
        }
        return modelBuilder.build();
    }

    public RestConnect withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public RestConnect withArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public RestConnect withVersion(String version) {
        this.version = version;
        return this;
    }
}

