/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.parameter;

import org.apache.commons.lang.StringUtils;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;

public class Parameter {
    private String externalName;
    private TypeDefinition typeDefinition;
    private String fixedValue;
    private boolean isPassword;
    private ParameterType parameterType;
    private boolean duplicatedName;

    public Parameter(String externalName, ParameterType parameterType, TypeDefinition typeDefinition) {
        this.externalName = externalName;
        this.typeDefinition = typeDefinition;
        this.parameterType = parameterType;
    }

    public Parameter(String externalName, ParameterType parameterType, TypeDefinition typeDefinition, boolean password) {
        this.externalName = externalName;
        this.typeDefinition = typeDefinition;
        this.isPassword = password;
        this.parameterType = parameterType;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public void setExternalName(String name) {
        this.externalName = name;
    }

    public String getInternalName() {
        if (this.duplicatedName) {
            return this.parameterType.getName() + this.externalName;
        }
        return this.externalName;
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public String getFixedValue() {
        return this.fixedValue;
    }

    public void setFixedValue(String fixedValue) {
        this.fixedValue = fixedValue;
    }

    public boolean hasFixedValue() {
        return !StringUtils.isBlank((String)this.fixedValue);
    }

    public boolean isPassword() {
        return this.isPassword;
    }

    public void setPassword(boolean password) {
        this.isPassword = password;
    }

    public boolean isDuplicatedName() {
        return this.duplicatedName;
    }

    public void setDuplicatedName(boolean duplicatedExternalName) {
        this.duplicatedName = duplicatedExternalName;
    }
}

