/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.internal.model.MavenDependency;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation.SmartConnectorOperationDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorPomDependency;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorSecuritySchemeDecoratorHelper;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorXMLConfig;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorXMLSchema;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorXMLSchemaLocation;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.SmartConnectorTypeDefinitionDecorator;

public abstract class SmartConnectorSecuritySchemeDecorator {
    protected final List<SmartConnectorXMLConfig> xmlConfigs = this.buildXmlConfigs();
    protected final List<SmartConnectorXMLSchema> xmlSchemas = this.buildXmlSchemas();
    protected final List<SmartConnectorXMLSchemaLocation> xmlSchemaLocations = this.buildXmlSchemaLocations();
    protected final String name;
    protected final List<SmartConnectorTypeDefinitionDecorator> configProperties;
    protected final List<Parameter> headers;
    protected final List<Parameter> queryParameters;
    protected final List<SmartConnectorPomDependency> pomDependencies;

    public SmartConnectorSecuritySchemeDecorator(APISecurityScheme securityScheme, HashMap<APISecurityScheme, String> securitySchemesNames) {
        this.name = this.buildName(securityScheme, securitySchemesNames);
        this.configProperties = SmartConnectorSecuritySchemeDecorator.buildConfigParameters(securityScheme, this.name);
        this.headers = SmartConnectorSecuritySchemeDecorator.buildHeaders(securityScheme, this.name);
        this.queryParameters = SmartConnectorSecuritySchemeDecorator.buildQueryParameters(securityScheme, this.name);
        this.pomDependencies = this.buildPomDependencies();
    }

    private static List<Parameter> buildQueryParameters(APISecurityScheme securityScheme, String prefix) {
        return SmartConnectorSecuritySchemeDecoratorHelper.buildPrefixedParameters(securityScheme.getQueryParameters(), prefix, ParameterType.QUERY);
    }

    private static List<Parameter> buildHeaders(APISecurityScheme securityScheme, String prefix) {
        return SmartConnectorSecuritySchemeDecoratorHelper.buildPrefixedParameters(securityScheme.getHeaders(), prefix, ParameterType.HEADER);
    }

    private static List<SmartConnectorTypeDefinitionDecorator> buildConfigParameters(APISecurityScheme securityScheme, String prefix) {
        return SmartConnectorOperationDecorator.buildDecoratedParameters(securityScheme.getConfigParameters(), prefix);
    }

    private String buildName(APISecurityScheme securityScheme, HashMap<APISecurityScheme, String> securitySchemesNames) {
        String prefix;
        if (securitySchemesNames.isEmpty()) {
            securitySchemesNames.put(securityScheme, "");
            return "";
        }
        Optional<APISecurityScheme> existingScheme = securitySchemesNames.keySet().stream().filter(x -> x.equals(securityScheme)).findFirst();
        if (existingScheme.isPresent()) {
            return securitySchemesNames.get(existingScheme.get());
        }
        String nameCandidate = prefix = SmartConnectorSecuritySchemeDecorator.getPrefixForSchemeType(securityScheme.getSchemeName());
        Integer i = 2;
        while (securitySchemesNames.containsValue(nameCandidate)) {
            nameCandidate = prefix + i.toString();
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        securitySchemesNames.put(securityScheme, nameCandidate);
        return nameCandidate;
    }

    private static String getPrefixForSchemeType(String schemeType) {
        if (schemeType.equals("Basic Authentication")) {
            return "basic-auth";
        }
        if (schemeType.equals("OAuth 2.0")) {
            return "oauth2";
        }
        if (schemeType.equals("Pass Through")) {
            return "pass-through";
        }
        if (schemeType.equals("Digest Authentication")) {
            return "digest";
        }
        if (schemeType.equals("Custom Authentication")) {
            return "custom-auth";
        }
        if (schemeType.equals("")) {
            return "unsecured";
        }
        return "security-scheme";
    }

    protected abstract List<SmartConnectorXMLSchemaLocation> buildXmlSchemaLocations();

    protected abstract List<SmartConnectorXMLSchema> buildXmlSchemas();

    protected abstract List<SmartConnectorXMLConfig> buildXmlConfigs();

    protected abstract List<SmartConnectorPomDependency> buildPomDependencies();

    public String getXmlConfigsString() {
        return SmartConnectorSecuritySchemeDecoratorHelper.getXmlConfigsString(this.xmlConfigs);
    }

    public String getXmlSchemasString() {
        return SmartConnectorSecuritySchemeDecoratorHelper.getXmlSchemasString(this.xmlSchemas);
    }

    public String getXmlSchemaLocationsString() {
        return SmartConnectorSecuritySchemeDecoratorHelper.getXmlSchemaLocationsString(this.xmlSchemaLocations);
    }

    public List<MavenDependency> getPomDependencies() {
        return this.pomDependencies.stream().map(x -> x.getMavenDependency()).collect(Collectors.toList());
    }

    public abstract String getHttpAuthorizationConfigString();

    public String getName() {
        return this.name;
    }

    public List<SmartConnectorTypeDefinitionDecorator> getConfigProperties() {
        return this.configProperties;
    }

    public List<Parameter> getHeaders() {
        return this.headers;
    }

    public List<Parameter> getQueryParameters() {
        return this.queryParameters;
    }

    protected SmartConnectorTypeDefinitionDecorator getPrefixedProperty(String propertyName) {
        Optional<SmartConnectorTypeDefinitionDecorator> parameter = this.getConfigProperties().stream().filter(x -> x.getExternalName().equalsIgnoreCase((this.name.isEmpty() ? "" : this.name + "-") + propertyName)).findFirst();
        return parameter.orElse(null);
    }

    protected String getConfigLineForProperty(String propertyName, String configName) {
        SmartConnectorTypeDefinitionDecorator property = this.getPrefixedProperty(propertyName);
        return configName + "=\"#[vars." + property.getPropertyName() + "]\"" + System.lineSeparator();
    }

    public String getXmlHttpConfigString(String modulePrefix, boolean setDefaultConnection) {
        StringBuilder builder = new StringBuilder();
        builder.append("<http:request-config").append(System.lineSeparator());
        builder.append("name=\"").append(modulePrefix).append("-httpreq-config");
        if (!this.name.isEmpty()) {
            builder.append("-").append(this.name);
        }
        builder.append("\"");
        if (setDefaultConnection) {
            builder.append(" xmlns:connection=\"true\"");
        }
        builder.append(System.lineSeparator());
        builder.append("basePath=\"#[vars.property_basePath]\">").append(System.lineSeparator());
        builder.append("<http:request-connection").append(System.lineSeparator());
        builder.append("host=\"#[vars.property_host]\"").append(System.lineSeparator());
        builder.append("protocol=\"#[vars.property_protocol]\"").append(System.lineSeparator());
        builder.append("port=\"#[vars.property_port]\"").append(System.lineSeparator());
        builder.append("proxyConfig=\"#[vars.property_proxyConfig]\">").append(System.lineSeparator());
        builder.append(this.getHttpAuthorizationConfigString()).append(System.lineSeparator());
        builder.append("</http:request-connection>").append(System.lineSeparator());
        builder.append("</http:request-config>").append(System.lineSeparator());
        return builder.toString();
    }

    public boolean equals(SmartConnectorSecuritySchemeDecorator other) {
        return other.getName().equals(this.name);
    }
}

