package org.mule.connectivity.restconnect.api;

public enum Parser {

    RAMLParser("RAMLParser"),
    AMF("AMF");

    private String name;

    Parser(String name){
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Parser getFromString(String parserName){
        if(parserName.equalsIgnoreCase(RAMLParser.name)){
            return RAMLParser;
        }
        if(parserName.equalsIgnoreCase(AMF.name)){
            return AMF;
        }

        throw new IllegalArgumentException("Parser " + parserName + " does not exist");
    }

}
