package org.mule.connectivity.restconnect.internal.model.type;

import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.TypeSource;

import javax.ws.rs.core.MediaType;
import java.util.List;

public class TypeDefinitionBuilder {

    private TypeDefinition typeDefinition;

    public TypeDefinitionBuilder(MediaType mediaType, TypeSource source, boolean required, boolean arrayType, boolean unionType) {
        typeDefinition = new TypeDefinition();
        typeDefinition.setMediaType(mediaType);
        typeDefinition.setSource(source);
        typeDefinition.setRequired(required);
        typeDefinition.setArrayType(arrayType);
        typeDefinition.setUnionType(unionType);
    }

    public TypeDefinitionBuilder withDescription(String description){
        typeDefinition.setDescription(description);
        return this;
    }

    public TypeDefinitionBuilder withDefaultValue(String defaultValue){
        typeDefinition.setDefaultValue(defaultValue);
        return this;
    }

    public TypeDefinitionBuilder withExample(String example){
        typeDefinition.setExample(example);
        return this;
    }

    public TypeDefinitionBuilder withAnnotatedDisplayName(String annotatedDisplayName){
        typeDefinition.setAnnotatedDisplayName(annotatedDisplayName);
        return this;
    }

    public TypeDefinitionBuilder withEnumValues(List<String> enumValues){
        typeDefinition.setEnumValues(enumValues);
        return this;
    }

    public static TypeDefinition buildHeaderType(){
        return new TypeDefinitionBuilder(MediaType.TEXT_PLAIN_TYPE, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING), false, false, false).build();
    }

    public static TypeDefinition buildImplicitUriParamType(){
        return new TypeDefinitionBuilder(MediaType.TEXT_PLAIN_TYPE, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING), true, false, false).build();
    }

    public static TypeDefinition buildSimplePrimitiveType(PrimitiveTypeSource.PrimitiveType primitiveType, boolean required){
        return new TypeDefinitionBuilder(MediaType.TEXT_PLAIN_TYPE, new PrimitiveTypeSource(primitiveType), required, false, false).build();
    }

    public TypeDefinition build(){
        return typeDefinition;
    }

}
