package org.mule.connectivity.restconnect.internal.model.typesource;

import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;

import java.util.List;

public class MultipartTypeSource implements TypeSource {

    private final List<Parameter> parts;
    private final XmlTypeSource xmlTypeSource;

    public MultipartTypeSource(List<Parameter> parts, XmlTypeSource xmlTypeSource) {
        this.parts = parts;
        this.xmlTypeSource = xmlTypeSource;
    }

    @Override
    public String getValue() {
        return this.xmlTypeSource.getValue();
    }

    public XmlTypeSource getXmlSource(){
        return this.xmlTypeSource;
    }

    public String getXmlSourceElementName(){
        return xmlTypeSource.getElementName();
    }

    public List<Parameter> getParts(){
        return this.parts;
    }

}
