package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.predicate;

import com.google.common.base.Predicate;
import org.raml.v2.api.model.v10.declarations.AnnotationRef;

import javax.annotation.Nullable;

import static org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils.OPERATION_NAME_ANNOTATION;


public class OperationNamePredicate implements Predicate<AnnotationRef> {

    @Override
    public boolean apply(@Nullable AnnotationRef input) {
        return input != null && OPERATION_NAME_ANNOTATION.equals(input.annotation().name());
    }

}
