/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.Path;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.mule.connectivity.restconnect.internal.util.DataWeaveUtils;
import org.mule.connectivity.restconnect.internal.util.JavaRequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TemplateEngine {
    private final Logger logger = LoggerFactory.getLogger(TemplateEngine.class);

    public abstract void applyTemplates() throws Exception;

    protected Path applyTemplate(String templateVm, Path output, VelocityContext context) throws Exception {
        output.getParent().toFile().mkdirs();
        context.put("StringUtils", StringUtils.class);
        context.put("DataWeaveUtils", DataWeaveUtils.class);
        context.put("JavaRequestUtils", JavaRequestUtils.class);
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(output.toFile()));){
            Template template = ve.getTemplate(templateVm, "UTF-8");
            template.merge((Context)context, (Writer)writer);
        }
        return output;
    }
}

