/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser;

import java.util.ArrayList;
import java.util.List;
import org.mule.connectivity.restconnect.internal.model.HTTPMethod;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.operation.OperationBuilder;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.modelGeneration.JsonSchemaPool;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.RamlParserTypeDefinitionFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.security.RamlParserSecuritySchemeFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.util.RamlParserUtils;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class RamlParserOperationGenerator {
    public static Operation generateOperation(Api api, Method method, JsonSchemaPool jsonSchemaPool) throws Exception {
        RamlParserTypeDefinitionFactory typeDefinitionFactory = new RamlParserTypeDefinitionFactory(method, jsonSchemaPool);
        Operation operation = new OperationBuilder().withFriendlyName(RamlParserUtils.getMethodDisplayName(method)).withAnnotatedDisplayName(RamlParserUtils.getAnnotatedOperationName(method)).withCanonicalName(RamlParserUtils.getCanonicalOperationName(method, RamlParserUtils.getMethodDisplayName(method))).withDescription(RamlParserUtils.getMethodDescription(method)).withHttpMethod(HTTPMethod.fromString(method.method())).withUri(method.resource().resourcePath()).withUriParams(RamlParserOperationGenerator.buildUriParams(method, jsonSchemaPool)).withQueryParams(RamlParserOperationGenerator.buildQueryParams(method, jsonSchemaPool)).withHeaders(RamlParserOperationGenerator.buildHeaders(method, jsonSchemaPool)).withInputMetadata(typeDefinitionFactory.constructInputMetadata()).withOutputMetadata(typeDefinitionFactory.constructOutputMetadata()).withSecuritySchemes(RamlParserOperationGenerator.buildSecuritySchemes(api, method, jsonSchemaPool)).build();
        return operation;
    }

    private static List<APISecurityScheme> buildSecuritySchemes(Api api, Method method, JsonSchemaPool jsonSchemaPool) throws Exception {
        return RamlParserSecuritySchemeFactory.getOperationSecuritySchemes(api, method, jsonSchemaPool);
    }

    private static List<Parameter> buildQueryParams(Method method, JsonSchemaPool jsonSchemaPool) throws Exception {
        return RamlParserUtils.getParameterList(method.queryParameters(), ParameterType.QUERY, jsonSchemaPool);
    }

    private static List<Parameter> buildUriParams(Method method, JsonSchemaPool jsonSchemaPool) throws Exception {
        ArrayList<Parameter> uriParameters = new ArrayList<Parameter>();
        for (Resource resource = method.resource(); resource != null; resource = resource.parentResource()) {
            for (Parameter uriParam : RamlParserUtils.getParameterList(resource.uriParameters(), ParameterType.URI, jsonSchemaPool)) {
                if (!uriParameters.stream().noneMatch(y -> y.getExternalName().equalsIgnoreCase(uriParam.getExternalName()))) continue;
                uriParameters.add(0, uriParam);
            }
        }
        return uriParameters;
    }

    private static List<Parameter> buildHeaders(Method method, JsonSchemaPool jsonSchemaPool) throws Exception {
        return RamlParserUtils.getParameterList(method.headers(), ParameterType.HEADER, jsonSchemaPool);
    }
}

