/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.security;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.security.BasicAuthScheme;
import org.mule.connectivity.restconnect.internal.model.security.CustomAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.DigestAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2AuthorizationCodeScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2ClientCredentialsScheme;
import org.mule.connectivity.restconnect.internal.model.security.PassThroughScheme;
import org.mule.connectivity.restconnect.internal.model.security.UnsecuredScheme;
import org.mule.connectivity.restconnect.internal.modelGeneration.JsonSchemaPool;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.security.RamlParserOauth2FlowsNaming;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.security.RamlParserSecuritySchemesNaming;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.util.RamlParserUtils;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;
import org.raml.v2.api.model.v10.security.SecurityScheme;
import org.raml.v2.api.model.v10.security.SecuritySchemePart;
import org.raml.v2.api.model.v10.system.types.AnnotableStringType;

public class RamlParserSecuritySchemeFactory {
    public static List<APISecurityScheme> getOperationSecuritySchemes(Api api, Method method, JsonSchemaPool jsonSchemaPool) throws Exception {
        List<SecurityScheme> globalSchemes = api.securedBy().stream().map(x -> x != null ? x.securityScheme() : null).collect(Collectors.toList());
        Resource endPoint = method.resource();
        List<SecurityScheme> endPointSchemes = endPoint.securedBy().stream().map(x -> x != null ? x.securityScheme() : null).collect(Collectors.toList());
        return RamlParserSecuritySchemeFactory.getMethodSecuritySchemes(method, endPointSchemes, globalSchemes, jsonSchemaPool);
    }

    private static List<APISecurityScheme> getAPISecuritySchemes(List<SecurityScheme> sourceSchemes, JsonSchemaPool jsonSchemaPool) throws Exception {
        LinkedList<APISecurityScheme> returnSchemes = new LinkedList<APISecurityScheme>();
        for (SecurityScheme scheme : sourceSchemes) {
            List<APISecurityScheme> generatedSchemes = RamlParserSecuritySchemeFactory.createSecuritySchemes(scheme, jsonSchemaPool);
            for (APISecurityScheme generatedScheme : generatedSchemes) {
                if (!returnSchemes.stream().noneMatch(x -> x.equals(generatedScheme))) continue;
                returnSchemes.add(generatedScheme);
            }
        }
        if (!sourceSchemes.isEmpty() && returnSchemes.isEmpty()) {
            throw new UnsupportedSecuritySchemeException("None of the specified security schemes ( " + RamlParserSecuritySchemeFactory.listSchemes(sourceSchemes) + ") are supported.");
        }
        return returnSchemes;
    }

    private static List<APISecurityScheme> getMethodSecuritySchemes(Method method, List<SecurityScheme> endPointSchemes, List<SecurityScheme> globalSchemes, JsonSchemaPool jsonSchemaPool) throws Exception {
        List<SecurityScheme> methodSchemes = method.securedBy().stream().map(x -> x != null ? x.securityScheme() : null).collect(Collectors.toList());
        if (!methodSchemes.isEmpty()) {
            return RamlParserSecuritySchemeFactory.getAPISecuritySchemes(methodSchemes, jsonSchemaPool);
        }
        if (!endPointSchemes.isEmpty()) {
            return RamlParserSecuritySchemeFactory.getAPISecuritySchemes(endPointSchemes, jsonSchemaPool);
        }
        if (!globalSchemes.isEmpty()) {
            return RamlParserSecuritySchemeFactory.getAPISecuritySchemes(globalSchemes, jsonSchemaPool);
        }
        LinkedList<APISecurityScheme> returnSchemes = new LinkedList<APISecurityScheme>();
        returnSchemes.add(new UnsecuredScheme());
        return returnSchemes;
    }

    private static List<APISecurityScheme> createSecuritySchemes(SecurityScheme securityScheme, JsonSchemaPool jsonSchemaPool) throws Exception {
        LinkedList<APISecurityScheme> apiSecuritySchemes = new LinkedList<APISecurityScheme>();
        if (securityScheme == null) {
            apiSecuritySchemes.add(new UnsecuredScheme());
            return apiSecuritySchemes;
        }
        String schemeType = securityScheme.type();
        if (RamlParserSecuritySchemesNaming.isBasicAuth(schemeType)) {
            apiSecuritySchemes.add(new BasicAuthScheme());
        } else if (RamlParserSecuritySchemesNaming.isPassThrough(schemeType)) {
            apiSecuritySchemes.add(RamlParserSecuritySchemeFactory.buildPassThroughSecurityScheme(securityScheme, jsonSchemaPool));
        } else if (RamlParserSecuritySchemesNaming.isOauth2(schemeType)) {
            for (String grant : securityScheme.settings().authorizationGrants()) {
                if (RamlParserOauth2FlowsNaming.isAuthorizationCode(grant)) {
                    apiSecuritySchemes.add(RamlParserSecuritySchemeFactory.buildOAuth2AuthorizationCodeSecurityScheme(securityScheme));
                    continue;
                }
                if (!RamlParserOauth2FlowsNaming.isClientCredentials(grant)) continue;
                apiSecuritySchemes.add(RamlParserSecuritySchemeFactory.buildOAuth2ClientCredentialsSecurityScheme(securityScheme));
            }
        } else if (RamlParserSecuritySchemesNaming.isDigestAuth(schemeType)) {
            apiSecuritySchemes.add(new DigestAuthenticationScheme());
        } else if (RamlParserSecuritySchemesNaming.isCustom(schemeType)) {
            apiSecuritySchemes.add(RamlParserSecuritySchemeFactory.buildCustomAuthenticationSecurityScheme(securityScheme, jsonSchemaPool));
        }
        return apiSecuritySchemes;
    }

    private static PassThroughScheme buildPassThroughSecurityScheme(SecurityScheme securityScheme, JsonSchemaPool jsonSchemaPool) throws Exception {
        SecuritySchemePart describedBy = securityScheme.describedBy();
        List<Parameter> queryParameters = RamlParserUtils.getParameterList(describedBy.queryParameters(), ParameterType.QUERY, jsonSchemaPool);
        List<Parameter> headers = RamlParserUtils.getParameterList(describedBy.headers(), ParameterType.HEADER, jsonSchemaPool);
        return new PassThroughScheme(queryParameters, headers);
    }

    private static APISecurityScheme buildCustomAuthenticationSecurityScheme(SecurityScheme securityScheme, JsonSchemaPool jsonSchemaPool) throws Exception {
        SecuritySchemePart describedBy = securityScheme.describedBy();
        List<Parameter> queryParameters = RamlParserUtils.getParameterList(describedBy.queryParameters(), ParameterType.QUERY, jsonSchemaPool);
        List<Parameter> headers = RamlParserUtils.getParameterList(describedBy.headers(), ParameterType.HEADER, jsonSchemaPool);
        return new CustomAuthenticationScheme(queryParameters, headers);
    }

    private static OAuth2AuthorizationCodeScheme buildOAuth2AuthorizationCodeSecurityScheme(SecurityScheme securityScheme) {
        String authorizationUri = RamlParserUtils.getValueFromAnnotableString((AnnotableStringType)securityScheme.settings().authorizationUri());
        String accessTokenUri = RamlParserUtils.getValueFromAnnotableString((AnnotableStringType)securityScheme.settings().accessTokenUri());
        List authorizationGrants = Arrays.asList((Object[])new String[]{"authorization_code"});
        List scopes = securityScheme.settings().scopes();
        return new OAuth2AuthorizationCodeScheme(authorizationUri, accessTokenUri, authorizationGrants, scopes);
    }

    private static OAuth2ClientCredentialsScheme buildOAuth2ClientCredentialsSecurityScheme(SecurityScheme securityScheme) {
        String authorizationUri = RamlParserUtils.getValueFromAnnotableString((AnnotableStringType)securityScheme.settings().authorizationUri());
        String accessTokenUri = RamlParserUtils.getValueFromAnnotableString((AnnotableStringType)securityScheme.settings().accessTokenUri());
        List authorizationGrants = Arrays.asList((Object[])new String[]{"client_credentials"});
        List scopes = securityScheme.settings().scopes();
        return new OAuth2ClientCredentialsScheme(authorizationUri, accessTokenUri, authorizationGrants, scopes);
    }

    private static String listSchemes(List<SecurityScheme> securitySchemes) {
        StringBuilder builder = new StringBuilder();
        for (SecurityScheme securityScheme : securitySchemes) {
            builder.append(securityScheme.type());
            builder.append("<");
            builder.append(securityScheme.name());
            builder.append(">");
            if (securityScheme.type().equals("OAuth 2.0")) {
                builder.append(" :");
                for (String grant : securityScheme.settings().authorizationGrants()) {
                    builder.append(" ");
                    builder.append(grant);
                }
            }
            builder.append(". ");
        }
        return builder.toString();
    }
}

