/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model;

import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectAPIModel;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;
import org.mule.connectivity.restconnect.internal.templateEngine.PojoFQNamePool;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.ModelDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation.DevKitOperationDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitSecuritySchemeDecorator;

public class DevKitConnectorModelDecorator
extends ModelDecorator {
    public static final String DEFAULT_ARTIFACT_ID_PREFIX = "mule-module-";
    public static final String DEFAULT_GROUP_ID = "org.mule.modules";
    private final List<DevKitOperationDecorator> decoratedOperations;
    private final String basePackage;
    private final Map<APISecurityScheme, String> securitySchemeNames;
    private List<DevKitSecuritySchemeDecorator> securitySchemes;
    private final PojoFQNamePool pojoFQNamePool = new PojoFQNamePool();

    public DevKitConnectorModelDecorator(RestConnectAPIModel model) {
        super(model);
        this.securitySchemeNames = new HashMap<APISecurityScheme, String>();
        this.securitySchemes = new LinkedList<DevKitSecuritySchemeDecorator>();
        this.basePackage = this.createBasePackage();
        this.decoratedOperations = this.buildDecoratedOperations();
    }

    private List<DevKitOperationDecorator> buildDecoratedOperations() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Operation operation : this.getOperations()) {
            builder.add((Object)new DevKitOperationDecorator(operation, this.basePackage, this.securitySchemeNames, this.pojoFQNamePool));
        }
        return builder.build();
    }

    private String createBasePackage() {
        if (super.getCustomPackage() != null) {
            return ParserUtils.removeJavaPackageUnwantedCharacters(this.getCustomPackage()) + "." + ParserUtils.removeJavaNameUnwantedCharacters(this.getApiName()).toLowerCase();
        }
        return ParserUtils.removeJavaPackageUnwantedCharacters(this.getGroupId()) + "." + ParserUtils.removeJavaNameUnwantedCharacters(this.getApiName()).toLowerCase();
    }

    @Override
    public String getGroupId() {
        return StringUtils.isNotBlank((CharSequence)super.getGroupId()) ? super.getGroupId() : DEFAULT_GROUP_ID;
    }

    @Override
    public String getArtifactId() {
        return StringUtils.isNotBlank((CharSequence)super.getArtifactId()) ? super.getArtifactId() : this.getDefaultArtifactId();
    }

    private String getDefaultArtifactId() {
        return DEFAULT_ARTIFACT_ID_PREFIX + ParserUtils.removeSpaces(this.getApiName()).toLowerCase();
    }

    public String getConnectorName() {
        String xmlValid = ParserUtils.getXmlName(this.getApiName());
        if (xmlValid.toLowerCase().startsWith("_xml") || xmlValid.toLowerCase().startsWith("xml") || xmlValid.toLowerCase().startsWith("_")) {
            return "connector" + xmlValid;
        }
        return xmlValid;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public String getClassName() {
        return ParserUtils.removeJavaNameUnwantedCharacters(this.getApiName()) + "Connector";
    }

    public List<DevKitOperationDecorator> getDecoratedOperations() {
        return this.decoratedOperations;
    }

    public String getBaseUriAsString() {
        return this.getBaseUri().toString();
    }

    @Override
    public Path getRootDir() {
        return this.model.getRootDir();
    }

    @Override
    public String getApiDescription() {
        if (StringUtils.isNotBlank((CharSequence)this.model.getApiDescription())) {
            String lineSeparator = System.getProperty("line.separator");
            StringBuilder builder = new StringBuilder();
            builder.append("/**").append(lineSeparator).append("*").append(this.model.getApiDescription().replace(lineSeparator, lineSeparator + "*")).append(lineSeparator).append("*/").append(lineSeparator);
            return builder.toString();
        }
        return "";
    }

    public List<DevKitSecuritySchemeDecorator> getSecuritySchemes() {
        if (this.securitySchemes.isEmpty()) {
            this.securitySchemes = this.getOperationsSecuritySchemes();
        }
        return this.securitySchemes;
    }

    private List<DevKitSecuritySchemeDecorator> getOperationsSecuritySchemes() {
        LinkedList<DevKitSecuritySchemeDecorator> operationSchemes = new LinkedList<DevKitSecuritySchemeDecorator>();
        for (DevKitOperationDecorator operation : this.getDecoratedOperations()) {
            for (DevKitSecuritySchemeDecorator scheme : operation.getSecuritySchemes()) {
                if (!operationSchemes.stream().noneMatch(x -> x.getApiSecurityScheme().equals(scheme.getApiSecurityScheme()))) continue;
                operationSchemes.add(scheme);
            }
        }
        return operationSchemes;
    }
}

