/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.operation;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.mule.connectivity.restconnect.exception.DuplicatedParameterNameException;
import org.mule.connectivity.restconnect.exception.InvalidSourceException;
import org.mule.connectivity.restconnect.internal.model.HTTPMethod;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;

public class OperationBuilder {
    private Operation operation = new Operation();

    public OperationBuilder withFriendlyName(String friendlyName) {
        this.operation.setFriendlyName(friendlyName);
        return this;
    }

    public OperationBuilder withAnnotatedDisplayName(String annotatedDisplayName) {
        this.operation.setAnnotatedDisplayName(annotatedDisplayName);
        return this;
    }

    public OperationBuilder withCanonicalName(String cannonicalName) {
        this.operation.setCanonicalName(cannonicalName);
        return this;
    }

    public OperationBuilder withDescription(String description) {
        this.operation.setDescription(description);
        return this;
    }

    public OperationBuilder withUri(String uri) {
        this.operation.setUri(uri);
        return this;
    }

    public OperationBuilder withHttpMethod(HTTPMethod method) {
        this.operation.setHttpMethod(method);
        return this;
    }

    public OperationBuilder withUriParams(List<Parameter> uriParams) {
        this.operation.setUriParameters(uriParams);
        return this;
    }

    public OperationBuilder withQueryParams(List<Parameter> queryParams) {
        this.operation.setQueryParameters(queryParams);
        return this;
    }

    public OperationBuilder withHeaders(List<Parameter> headers) {
        this.operation.setHeaders(headers);
        return this;
    }

    public OperationBuilder withInputMetadata(TypeDefinition inputMetadata) {
        this.operation.setInputMetadata(inputMetadata);
        return this;
    }

    public OperationBuilder withOutputMetadata(TypeDefinition outputMetadata) {
        this.operation.setOutputMetadata(outputMetadata);
        return this;
    }

    public OperationBuilder withSecuritySchemes(List<APISecurityScheme> securitySchemes) {
        this.operation.setSecuritySchemes(securitySchemes);
        return this;
    }

    public OperationBuilder withUserSelectedSecuritySchemes(boolean userSelectedSecuritySchemes) {
        this.operation.setUserSelectedSecuritySchemes(userSelectedSecuritySchemes);
        return this;
    }

    private List<Parameter> buildParameters() throws InvalidSourceException {
        this.disambiguateAndValidateUniqueParameterNames(this.operation.getQueryParameters(), this.operation.getUriParameters(), this.operation.getHeaders());
        LinkedList<Parameter> allParams = new LinkedList<Parameter>();
        allParams.addAll(this.operation.getQueryParameters());
        allParams.addAll(this.operation.getUriParameters());
        allParams.addAll(this.operation.getHeaders());
        return allParams;
    }

    @SafeVarargs
    protected final void disambiguateAndValidateUniqueParameterNames(List<Parameter> ... parameterSources) throws InvalidSourceException {
        this.disambiguateParameters(parameterSources);
        this.validateParameters(parameterSources);
    }

    private void validateParameters(List<Parameter>[] parameterSources) {
        ArrayList<String> keys = new ArrayList<String>();
        for (List<Parameter> parameterSource : parameterSources) {
            for (Parameter param : parameterSource) {
                if (keys.stream().anyMatch(str -> str.equals(param.getInternalName()))) {
                    throw new InvalidSourceException("Invalid spec: Duplicated parameter names", new DuplicatedParameterNameException(param.getExternalName(), this.operation.getCanonicalName(), this.operation.getUri()));
                }
                keys.add(param.getInternalName());
            }
        }
    }

    private void disambiguateParameters(List<Parameter>[] parameterSources) {
        ArrayList<Parameter> existingParameters = new ArrayList<Parameter>();
        LinkedList<Parameter> allParams = new LinkedList<Parameter>();
        for (List<Parameter> parameterSource : parameterSources) {
            allParams.addAll(parameterSource);
        }
        for (Parameter parameter : allParams) {
            for (Parameter existingParam : existingParameters) {
                if (!existingParam.getExternalName().equalsIgnoreCase(parameter.getExternalName())) continue;
                parameter.setDuplicatedName(true);
                existingParam.setDuplicatedName(true);
            }
            existingParameters.add(parameter);
        }
    }

    public Operation build() throws InvalidSourceException {
        this.operation.setParameters(this.buildParameters());
        return this.operation;
    }
}

