/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf.security;

import amf.client.model.StrField;
import amf.client.model.domain.DomainElement;
import amf.client.model.domain.EndPoint;
import amf.client.model.domain.OAuth2Settings;
import amf.client.model.domain.Operation;
import amf.client.model.domain.ParametrizedSecurityScheme;
import amf.client.model.domain.SecurityScheme;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.security.BasicAuthScheme;
import org.mule.connectivity.restconnect.internal.model.security.CustomAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.DigestAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2AuthorizationCodeScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2ClientCredentialsScheme;
import org.mule.connectivity.restconnect.internal.model.security.PassThroughScheme;
import org.mule.connectivity.restconnect.internal.model.security.UnsecuredScheme;
import org.mule.connectivity.restconnect.internal.modelGeneration.JsonSchemaPool;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.security.AMFOauth2FlowsNaming;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.security.AMFSecuritySchemesNaming;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.util.AMFParserUtil;
import org.mule.connectivity.restconnect.internal.modelGeneration.common.security.SecuritySchemeFactory;

public class AMFSecuritySchemeFactory {
    public static List<APISecurityScheme> getSchemesForOperation(EndPoint endPoint, Operation operation, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        List<SecurityScheme> globalSchemes = endPoint.security().stream().map(x -> AMFSecuritySchemeFactory.getScheme((DomainElement)x)).collect(Collectors.toList());
        List<SecurityScheme> endPointSchemes = endPoint.security().stream().map(x -> AMFSecuritySchemeFactory.getScheme((DomainElement)x)).collect(Collectors.toList());
        List<SecurityScheme> operationSchemes = operation.security().stream().map(x -> AMFSecuritySchemeFactory.getScheme(x)).collect(Collectors.toList());
        return AMFSecuritySchemeFactory.getOperationSecuritySchemes(operationSchemes, endPointSchemes, globalSchemes, jsonSchemaPool);
    }

    private static List<APISecurityScheme> getOperationSecuritySchemes(List<SecurityScheme> operationSchemes, List<SecurityScheme> endPointSchemes, List<SecurityScheme> globalSchemes, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        List<SecurityScheme> securitySchemesForOperation = SecuritySchemeFactory.getSecuritySchemesForOperation(operationSchemes, endPointSchemes, globalSchemes);
        if (!securitySchemesForOperation.isEmpty()) {
            return AMFSecuritySchemeFactory.getAPISecuritySchemes(securitySchemesForOperation, jsonSchemaPool);
        }
        LinkedList<APISecurityScheme> returnSchemes = new LinkedList<APISecurityScheme>();
        returnSchemes.add(new UnsecuredScheme());
        return returnSchemes;
    }

    private static List<APISecurityScheme> getAPISecuritySchemes(List<SecurityScheme> sourceSchemes, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        LinkedList<APISecurityScheme> returnSchemes = new LinkedList<APISecurityScheme>();
        for (SecurityScheme scheme : sourceSchemes) {
            List<APISecurityScheme> generatedSchemes = AMFSecuritySchemeFactory.createSecuritySchemes(scheme, jsonSchemaPool);
            for (APISecurityScheme generatedScheme : generatedSchemes) {
                if (!returnSchemes.stream().noneMatch(x -> x.equals(generatedScheme))) continue;
                returnSchemes.add(generatedScheme);
            }
        }
        if (!sourceSchemes.isEmpty() && returnSchemes.isEmpty()) {
            throw new UnsupportedSecuritySchemeException("None of the specified security schemes ( " + AMFSecuritySchemeFactory.listSchemes(sourceSchemes) + ") are supported.");
        }
        return returnSchemes;
    }

    private static List<APISecurityScheme> createSecuritySchemes(SecurityScheme scheme, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        ArrayList<APISecurityScheme> apiSecuritySchemes = new ArrayList<APISecurityScheme>();
        if (scheme == null || !scheme.type().nonEmpty()) {
            apiSecuritySchemes.add(new UnsecuredScheme());
            return apiSecuritySchemes;
        }
        String schemeType = scheme.type().value();
        if (AMFSecuritySchemesNaming.isBasicAuth(schemeType)) {
            apiSecuritySchemes.add(new BasicAuthScheme());
        } else if (AMFSecuritySchemesNaming.isPassThrough(schemeType)) {
            apiSecuritySchemes.add(AMFSecuritySchemeFactory.buildPassThroughSecurityScheme(scheme, jsonSchemaPool));
        } else if (AMFSecuritySchemesNaming.isOauth2(schemeType)) {
            OAuth2Settings oAuth2Settings = (OAuth2Settings)scheme.settings();
            if (AMFOauth2FlowsNaming.isAuthorizationCode(oAuth2Settings)) {
                apiSecuritySchemes.add(AMFSecuritySchemeFactory.buildOAuth2AuthorizationCodeSecurityScheme(oAuth2Settings));
            } else if (AMFOauth2FlowsNaming.isClientCredentials(oAuth2Settings)) {
                apiSecuritySchemes.add(AMFSecuritySchemeFactory.buildOAuth2ClientCredentialsSecurityScheme(oAuth2Settings));
            }
        } else if (AMFSecuritySchemesNaming.isDigestAuth(schemeType)) {
            apiSecuritySchemes.add(new DigestAuthenticationScheme());
        } else if (AMFSecuritySchemesNaming.isCustom(schemeType)) {
            apiSecuritySchemes.add(AMFSecuritySchemeFactory.buildCustomAuthenticationScheme(scheme, jsonSchemaPool));
        }
        return apiSecuritySchemes;
    }

    private static SecurityScheme getScheme(DomainElement domainElement) {
        if (domainElement instanceof ParametrizedSecurityScheme) {
            ParametrizedSecurityScheme securityScheme = (ParametrizedSecurityScheme)domainElement;
            if (securityScheme.scheme() == null) {
                return null;
            }
            if (securityScheme.scheme().isLink() && securityScheme.scheme().linkTarget() != null) {
                return (SecurityScheme)securityScheme.scheme().linkTarget().get();
            }
            return securityScheme.scheme();
        }
        return (SecurityScheme)domainElement;
    }

    private static PassThroughScheme buildPassThroughSecurityScheme(SecurityScheme securityScheme, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        List<Parameter> queryParameters = AMFParserUtil.getParameterList(securityScheme.queryParameters(), ParameterType.SECURITY, jsonSchemaPool);
        List<Parameter> headers = AMFParserUtil.getParameterList(securityScheme.headers(), ParameterType.SECURITY, jsonSchemaPool);
        return new PassThroughScheme(queryParameters, headers);
    }

    private static CustomAuthenticationScheme buildCustomAuthenticationScheme(SecurityScheme securityScheme, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        List<Parameter> queryParameters = AMFParserUtil.getParameterList(securityScheme.queryParameters(), ParameterType.SECURITY, jsonSchemaPool);
        List<Parameter> headers = AMFParserUtil.getParameterList(securityScheme.headers(), ParameterType.SECURITY, jsonSchemaPool);
        return new CustomAuthenticationScheme(queryParameters, headers);
    }

    private static OAuth2AuthorizationCodeScheme buildOAuth2AuthorizationCodeSecurityScheme(OAuth2Settings settings) {
        String authorizationUri = settings.authorizationUri().value();
        String accessTokenUri = settings.accessTokenUri().value();
        List authorizationGrants = Arrays.asList((Object[])new String[]{"authorization_code"});
        List<String> scopes = settings.scopes().stream().map(s -> s.name().value()).collect(Collectors.toList());
        return new OAuth2AuthorizationCodeScheme(authorizationUri, accessTokenUri, authorizationGrants, scopes);
    }

    private static OAuth2ClientCredentialsScheme buildOAuth2ClientCredentialsSecurityScheme(OAuth2Settings settings) {
        String authorizationUri = settings.authorizationUri().value();
        String accessTokenUri = settings.accessTokenUri().value();
        List authorizationGrants = Arrays.asList((Object[])new String[]{"client_credentials"});
        List<String> scopes = settings.scopes().stream().map(s -> s.name().value()).collect(Collectors.toList());
        return new OAuth2ClientCredentialsScheme(authorizationUri, accessTokenUri, authorizationGrants, scopes);
    }

    private static String listSchemes(List<SecurityScheme> securitySchemes) {
        StringBuilder builder = new StringBuilder();
        for (SecurityScheme securityScheme : securitySchemes) {
            builder.append(securityScheme.name());
            builder.append(":");
            builder.append(securityScheme.type().value());
            if (securityScheme.type().value().equals("OAuth 2.0") && securityScheme.settings() != null) {
                OAuth2Settings settings = (OAuth2Settings)securityScheme.settings();
                builder.append(" :");
                if (settings.authorizationGrants() != null && settings.authorizationGrants().size() > 0) {
                    for (StrField grant : settings.authorizationGrants()) {
                        builder.append(" ");
                        builder.append(grant.value());
                    }
                }
            }
            builder.append(". ");
        }
        return builder.toString();
    }
}

