/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.util;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.XJC;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.jar.JarEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.DefaultGenerationConfig;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson2Annotator;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.SchemaStore;
import org.jsonschema2pojo.rules.RuleFactory;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.internal.model.typesource.JsonTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.MultipartTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.TypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.XmlTypeSource;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;
import org.xml.sax.InputSource;

public class FileGenerationUtils {
    private static GenerationConfig config = new DefaultGenerationConfig(){

        public boolean isGenerateBuilders() {
            return true;
        }

        public String getTargetVersion() {
            return "1.7";
        }

        public boolean isIncludeAdditionalProperties() {
            return false;
        }

        public boolean isIncludeHashcodeAndEquals() {
            return false;
        }
    };

    public static String generatePojo(TypeSource source, String opName, File outputDir, String basePackage) throws GenerationException {
        if (source instanceof XmlTypeSource) {
            return FileGenerationUtils.generatePojo((XmlTypeSource)source, opName, outputDir, basePackage);
        }
        if (source instanceof JsonTypeSource) {
            return FileGenerationUtils.generatePojo((JsonTypeSource)source, opName, outputDir, basePackage);
        }
        if (source instanceof MultipartTypeSource) {
            return FileGenerationUtils.generatePojo(((MultipartTypeSource)source).getXmlSource(), opName, outputDir, basePackage);
        }
        throw new IllegalArgumentException("Typesource doesn't support POJO generation.");
    }

    private static String generatePojo(XmlTypeSource source, String opName, File outputDir, String basePackage) throws GenerationException {
        try {
            SchemaCompiler sc = XJC.createSchemaCompiler();
            String pojoPackage = basePackage + ".pojo." + ParserUtils.removeJavaNameUnwantedCharacters(opName).toLowerCase();
            InputSource inputSource = StringUtils.isNotBlank((CharSequence)source.getSchemaPath()) ? new InputSource(source.getSchemaPath()) : FileGenerationUtils.getInputSourceWithMockFile(source);
            sc.getOptions().parseArgument(new String[]{"-XautoNameResolution"}, 0);
            sc.parseSchema(inputSource);
            S2JJAXBModel model = sc.bind();
            sc.setDefaultPackageName(pojoPackage);
            S2JJAXBModel newModel = sc.bind();
            if (newModel != null) {
                model = newModel;
            }
            JCodeModel jCodeModel = model.generateCode(null, null);
            jCodeModel.build(outputDir);
            return FileGenerationUtils.findBestMatchClassName(model, source.getElementName());
        }
        catch (Throwable e) {
            throw new GenerationException("Error generating Pojo from xsd", e);
        }
    }

    public static String findBestMatchClassName(S2JJAXBModel model, String elementName) {
        for (Mapping mapping : model.getMappings()) {
            if (!mapping.getElement().getLocalPart().equalsIgnoreCase(elementName)) continue;
            return mapping.getType().getTypeClass().fullName();
        }
        return ((Mapping)model.getMappings().iterator().next()).getType().getTypeClass().fullName();
    }

    private static InputSource getInputSourceWithMockFile(XmlTypeSource source) throws IOException {
        File temp = File.createTempFile("schema", ".xsd");
        BufferedWriter bw = new BufferedWriter(new FileWriter(temp));
        bw.write(source.getValue());
        bw.close();
        FileInputStream schemaStream = new FileInputStream(temp);
        InputSource is = new InputSource(schemaStream);
        if (StringUtils.isNotBlank((CharSequence)source.getElementName())) {
            is.setSystemId(temp.toURI().toString() + "#" + source.getElementName());
        } else {
            is.setSystemId(temp.toURI().toString());
        }
        return is;
    }

    private static String generatePojo(JsonTypeSource source, String opName, File outputDir, String basePackage) throws GenerationException {
        try {
            SchemaMapper mapper = new SchemaMapper(new RuleFactory(config, (Annotator)new Jackson2Annotator(config), new SchemaStore()), new SchemaGenerator());
            JCodeModel codeModel = new JCodeModel();
            JType generatedModel = mapper.generate(codeModel, opName, basePackage + ".pojo." + ParserUtils.removeJavaNameUnwantedCharacters(opName).toLowerCase(), source.getValue());
            codeModel.build(outputDir);
            return generatedModel.fullName();
        }
        catch (Throwable e) {
            throw new GenerationException("Error generating Pojo from JSON", e);
        }
    }

    public static String writeSchema(TypeSource source, String name, Path outputDir) throws IOException {
        String filename = name + "." + FileGenerationUtils.getExtension(source);
        FileUtils.writeStringToFile((File)outputDir.resolve(filename).toFile(), (String)source.getValue());
        return filename;
    }

    private static String getExtension(TypeSource source) {
        if (source instanceof XmlTypeSource) {
            return "xsd";
        }
        if (source instanceof JsonTypeSource) {
            return "json";
        }
        if (source instanceof MultipartTypeSource) {
            return "xsd";
        }
        throw new IllegalArgumentException("Typesource doesn't support schema generation.");
    }

    public static String getSchemaFormat(TypeSource source) {
        if (source instanceof XmlTypeSource) {
            return "application/xml+schema";
        }
        if (source instanceof JsonTypeSource) {
            return "application/json+schema";
        }
        if (source instanceof MultipartTypeSource) {
            return "application/xml+schema";
        }
        throw new IllegalArgumentException("Typesource doesn't support schema generation.");
    }

    public static void generateJarFileFromDirectory(Path directory, Path output) throws Exception {
        FileGenerationUtils.generateJarArchiveFromDirectory(directory.toFile(), output.toFile());
    }

    private static void generateJarArchiveFromDirectory(File inputDirectory, File outputFile) throws Exception {
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream);
        ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedStream);
        FileGenerationUtils.addToJar(zipOutputStream, inputDirectory, inputDirectory.getAbsolutePath().length());
        zipOutputStream.finish();
        zipOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToJar(ZipOutputStream outputStream, File toBeJared, Integer directoryLength) throws Exception {
        if (toBeJared == null || !toBeJared.exists()) {
            return;
        }
        String pathInZip = toBeJared.getAbsolutePath().substring(directoryLength, toBeJared.getAbsolutePath().length()).replace("\\", "/");
        if (pathInZip.startsWith("/")) {
            pathInZip = pathInZip.substring(1, pathInZip.length());
        }
        if (toBeJared.isDirectory()) {
            if (!pathInZip.isEmpty()) {
                if (!pathInZip.endsWith("/")) {
                    pathInZip = pathInZip + "/";
                }
                JarEntry entry = new JarEntry(pathInZip);
                entry.setTime(toBeJared.lastModified());
                outputStream.putNextEntry(entry);
                outputStream.closeEntry();
            }
            for (File nestedFile : toBeJared.listFiles()) {
                FileGenerationUtils.addToJar(outputStream, nestedFile, directoryLength);
            }
            return;
        }
        JarEntry entry = new JarEntry(pathInZip);
        entry.setTime(toBeJared.lastModified());
        outputStream.putNextEntry(entry);
        byte[] buffer = new byte[12000];
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(toBeJared));){
            int count;
            while ((count = in.read(buffer)) != -1) {
                outputStream.write(buffer, 0, count);
            }
            outputStream.closeEntry();
        }
    }
}

