/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.security;

import java.util.List;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;

public abstract class OAuth2Scheme
extends APISecurityScheme {
    private String authorizationUri;
    private String accessTokenUri;
    private List<String> authorizationGrants;
    private List<String> scopes;
    public static final String OAUTH2_GRANT_AUTHORIZATION_CODE = "authorization_code";
    public static final String OAUTH2_GRANT_CLIENT_CREDENTIALS = "client_credentials";

    public OAuth2Scheme(String authorizationUri, String accessTokenUri, List<String> grants, List<String> scopes) {
        this.authorizationUri = authorizationUri;
        this.authorizationGrants = grants;
        this.accessTokenUri = accessTokenUri;
        this.scopes = scopes;
        this.initializeConfigParameters();
    }

    @Override
    public String getSchemeName() {
        return "OAuth 2.0";
    }

    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    public String getAccessTokenUri() {
        return this.accessTokenUri;
    }

    public List<String> getAuthorizationGrants() {
        return this.authorizationGrants;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public boolean supportsAuthorizationGrant(String authorizationGrant) {
        return this.authorizationGrants.contains(authorizationGrant);
    }

    @Override
    protected boolean equalProperties(APISecurityScheme scheme) {
        OAuth2Scheme other = (OAuth2Scheme)scheme;
        return other.getScopes().equals(this.getScopes()) && this.equalOrBothNull(other.getAuthorizationUri(), this.getAuthorizationUri()) && this.equalOrBothNull(other.getAccessTokenUri(), this.getAccessTokenUri()) && other.getAuthorizationGrants().equals(this.getAuthorizationGrants());
    }

    protected void addScopeConfigParameter() {
        if (this.getScopes() != null && this.getScopes().size() > 0) {
            StringBuilder scopeBuilder = new StringBuilder();
            for (String scope : this.getScopes()) {
                scopeBuilder.append(scope);
                scopeBuilder.append(" ");
            }
            this.configParameters.add(OAuth2Scheme.getSecuritySchemeParameter("scopes", "scopes", PrimitiveTypeSource.PrimitiveType.STRING, "List of requested scopes separated by spaces", scopeBuilder.toString(), scopeBuilder.toString(), true, false));
        }
    }

    protected boolean equalOrBothNull(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }
}

