/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.connectormodel;

import static org.mule.connectivity.restconnect.internal.connectormodel.Protocol.HTTP;
import static org.mule.connectivity.restconnect.internal.connectormodel.Protocol.HTTPS;
import static org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils.getXmlName;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.Pagination;
import org.mule.connectivity.restconnect.internal.connectormodel.uri.BaseUri;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectorModel {

  private String connectorName;
  private String connectorXmlName;
  private List<Protocol> protocols;
  private Map<String, Pagination> paginations = new HashMap<>();

  private String description;
  private BaseUri baseUri;
  private ConnectorCategory category;
  private List<ConnectorOperation> operations;

  private String mvnGroupId;
  private String mvnArtifactId;
  private String mvnVersion;
  private String basePackage;
  private String extensionXml;
  private Boolean skipOutputTypeValidation;
  private QueryParamArrayFormat queryParamArrayFormat;

  public ConnectorModel(String connectorName,
                        String description,
                        String mvnGroupId,
                        String mvnArtifactId,
                        String mvnVersion,
                        String basePackage,
                        ConnectorCategory category,
                        BaseUri baseUri,
                        List<Protocol> protocols,
                        List<ConnectorOperation> operations,
                        List<Pagination> paginations,
                        String extensionXml,
                        Boolean skipOutputTypeValidation,
                        QueryParamArrayFormat queryParamArrayFormat) {

    this.connectorName = connectorName;
    this.connectorXmlName = getXmlName(connectorName);

    this.protocols = protocols;
    this.description = description;
    this.mvnGroupId = mvnGroupId;
    this.mvnArtifactId = mvnArtifactId;
    this.mvnVersion = mvnVersion;
    this.basePackage = basePackage;
    this.category = category;
    this.baseUri = baseUri;
    this.operations = operations;
    this.extensionXml = extensionXml;
    this.skipOutputTypeValidation = skipOutputTypeValidation;
    if (paginations != null) {
      paginations.forEach(paging -> this.paginations.put(paging.getName(), paging));
    }
    this.queryParamArrayFormat = queryParamArrayFormat;
  }

  public String getConnectorName() {
    return connectorName;
  }

  public List<ConnectorOperation> getOperations() {
    return operations;
  }

  public String getMvnGroupId() {
    return mvnGroupId;
  }

  public String getMvnArtifactId() {
    return mvnArtifactId;
  }

  public String getMvnVersion() {
    return mvnVersion;
  }

  public String getBasePackage() {
    return basePackage;
  }

  public ConnectorCategory getCategory() {
    return category;
  }

  public BaseUri getBaseUri() {
    return baseUri;
  }

  public String getConnectorXmlName() {
    return connectorXmlName;
  }

  public String getApiDescription() {
    return description;
  }

  public Pagination getPagination(String pagingName) {
    return paginations.getOrDefault(pagingName, null);
  }

  public int getPaginationStrategies() {
    return paginations.size();
  }

  public boolean supportsHTTP() {
    return protocols.contains(HTTP);
  }

  public boolean supportsHTTPS() {
    return protocols.contains(HTTPS);
  }

  public String getExtensionXml() {
    return extensionXml;
  }

  public Boolean getSkipOutputTypeValidation() {
    return skipOutputTypeValidation;
  }

  public QueryParamArrayFormat getQueryParamArrayFormat() {
    return queryParamArrayFormat;
  }
}
