/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.OutPaginationParameter;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.PaginationParameter;
import org.mule.connectors.restconnect.commons.api.operation.paging.PageNumberPagingProvider;

import java.nio.file.Path;

public class SdkPageNumberPaginationOperation extends AbstractSdkPaginationOperation {

  public static final String PAGE_NUMBER_PARAM_NAME = "pageNumberParamName";
  public static final String INITIAL_PAGE_NUMBER = "initialPageNumber";

  public SdkPageNumberPaginationOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                                          ConnectorOperation operation)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, operation);
  }

  @Override
  public String getInitialPagingParameterSummary() {
    return "The initial page to get in the first request";
  }

  @Override
  public Class getPagingProvider() {
    return PageNumberPagingProvider.class;
  }

  @Override
  public String getTokenParamName() {
    PaginationParameter parameter = getPagination().getParameter(PAGE_NUMBER_PARAM_NAME);

    return (parameter == null) ? null : ((OutPaginationParameter) parameter).getValue();
  }

  @Override
  public String getInitialParamName() {
    return INITIAL_PAGE_NUMBER;
  }
}
