/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import static org.apache.commons.lang3.StringUtils.isNotBlank;
import static org.mule.connectivity.restconnect.internal.util.NamingUtil.isFriendlyName;
import static org.mule.connectivity.restconnect.internal.validation.ValidationRule.Level.ERROR;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.validation.PreValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;

import java.util.LinkedList;
import java.util.List;

public class ConnectorNameMustBeFriendlyRule extends PreValidationRule {

  //R011
  public ConnectorNameMustBeFriendlyRule() {
    super("connectorName property seems not to be a friendly name",
          "The connectorName declared in the descriptor should be a human readable name separated with spaces.",
          ERROR);
  }

  @Override
  public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {

    List<ValidationResult> validationResults = new LinkedList<>();

    String connectorName = connectorDescriptor.getConnectorName();

    if (isNotBlank(connectorName) && !isFriendlyName(connectorName)) {
      validationResults.add(getValidationError(connectorName));
    }

    return validationResults;
  }

  private ValidationResult getValidationError(String name) {
    return new ValidationResult(this, "connectorName : " + name);
  }
}
