/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import static org.mule.connectivity.restconnect.internal.validation.ValidationRule.Level.ERROR;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.validation.PreValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils;

import java.util.LinkedList;
import java.util.List;

public class GavArtifactIdMustBeValidRule extends PreValidationRule {

  //R008
  public GavArtifactIdMustBeValidRule() {
    super("Descriptor connectorGav's artifactId must ve a valid Maven artifactId",
          "The artifactId defined in the connector descriptor for the connectorGav can contain lowercase letters and no strange symbols.",
          ERROR);
  }

  @Override
  public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {

    List<ValidationResult> validationResults = new LinkedList<>();

    String artifactId = connectorDescriptor.getConnectorGav().getArtifactId();
    String validArtifactId = XmlUtils.removeMavenArtifactUnwantedCharacters(artifactId);

    if (!artifactId.equalsIgnoreCase(validArtifactId)) {
      validationResults.add(getValidationError());
    }

    return validationResults;
  }

  private ValidationResult getValidationError() {
    return new ValidationResult(this, "'artifactId' property declared in the connector descriptor's 'connectorGav' property");
  }
}
