/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.amf;

import static javax.ws.rs.core.MediaType.APPLICATION_XML_TYPE;

import java.io.StringWriter;
import java.util.function.Supplier;

import javax.ws.rs.core.MediaType;

import amf.client.model.domain.AnyShape;
import amf.plugins.xml.transformer.TypeToXmlSchema;
import org.apache.ws.commons.schema.XmlSchema;

public class AMFTypeSchemaSupplier implements Supplier<String> {

  private AnyShape shape;
  private MediaType mediaType;

  AMFTypeSchemaSupplier(AnyShape shape, MediaType mediaType) {
    this.shape = shape;
    this.mediaType = mediaType;
  }

  @Override
  public String get() {
    if (mediaType != null && mediaType.equals(APPLICATION_XML_TYPE)) {
      return buildXmlTypeSchema(shape);
    } else {
      return shape.buildJsonSchema();
    }
  }

  private String buildXmlTypeSchema(AnyShape anyShape) {
    XmlSchema xmlSchema = TypeToXmlSchema.transform("root", anyShape._internal());
    xmlSchema.setTargetNamespace("http://validationnamespace.raml.org");

    StringWriter schemaWriter = new StringWriter();
    xmlSchema.write(schemaWriter);
    return schemaWriter.toString();
  }
}
