/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.InPaginationParameter;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.OutPaginationParameter;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.PaginationParameter;
import org.mule.connectivity.restconnect.internal.templating.sdk.AbstractSdkPaginationOperation;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectors.restconnect.commons.api.operation.paging.MarkerPagingProvider;

public class SdkMarkerPaginationOperation
extends AbstractSdkPaginationOperation {
    public static final String NEXT_TOKEN_EXPRESSION = "nextTokenExpression";
    public static final String NEXT_TOKEN_PARAM_NAME = "nextTokenParamName";

    public SdkMarkerPaginationOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation) throws TemplatingException {
        super(outputDir, connectorModel, sdkConnector, operation);
    }

    @Override
    public String getInitialPagingParameterSummary() {
        return "";
    }

    @Override
    public ParameterSpec generateInitialPagingParameter() {
        return null;
    }

    @Override
    public CodeBlock getPagingMethodOperation() {
        CodeBlock.Builder paginationBody = CodeBlock.builder();
        paginationBody.addStatement("return new $T($S, $S, requestFactory, expressionLanguage, streamingHelper, $S, resolveDefaultResponseMediaType(config), overrides.getResponseTimeoutAsMillis())", new Object[]{this.getPagingProvider(), this.generateTokenParameter().name, this.getNextTokenExpression(), this.getPayloadExpression()});
        return paginationBody.build();
    }

    @Override
    public Class getPagingProvider() {
        return MarkerPagingProvider.class;
    }

    private String getNextTokenExpression() {
        PaginationParameter parameter = this.getPagination().getParameter(NEXT_TOKEN_EXPRESSION);
        return parameter == null ? null : ((InPaginationParameter)parameter).getValueExtraction().getContent();
    }

    @Override
    public String getTokenParamName() {
        PaginationParameter parameter = this.getPagination().getParameter(NEXT_TOKEN_PARAM_NAME);
        return parameter == null ? null : ((OutPaginationParameter)parameter).getValue();
    }

    @Override
    public String getInitialParamName() {
        return NEXT_TOKEN_EXPRESSION;
    }

    private ParameterSpec generateTokenParameter() {
        return ParameterSpec.builder(String.class, (String)this.getInitialParamName(), (Modifier[])new Modifier[0]).build();
    }
}

