/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.util;

import com.google.common.base.CaseFormat;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JavaUtils {
    private static final int DEFAULT_MAX_TEXT_LENGTH = 128;
    private static final List<String> reservedJavaWords = Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while");

    private JavaUtils() {
    }

    public static String getJavaLowerCamelNameFromXml(String name) {
        return JavaUtils.removeJavaNameUnwantedCharacters(CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, name));
    }

    public static String getJavaUpperCamelNameFromXml(String name) {
        return JavaUtils.removeJavaNameUnwantedCharacters(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, name));
    }

    public static String getJavaConstantNameFromXml(String name) {
        return JavaUtils.removeJavaNameUnwantedCharacters(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, name));
    }

    public static String removeJavaNameUnwantedCharacters(String name) {
        return JavaUtils.removeJavaNameUnwantedCharacters(name, "j");
    }

    public static String removeJavaNameUnwantedCharacters(String name, String sanitizeSufix) {
        if (name == null) {
            return null;
        }
        String javaName = name.replaceAll("[^a-zA-Z0-9_]", "");
        if (javaName.matches("^[0-9_].*")) {
            javaName = sanitizeSufix + javaName;
        }
        if (StringUtils.isBlank((CharSequence)javaName)) {
            return "empty";
        }
        return javaName;
    }

    public static String removeJavaPackageUnwantedCharacters(String name) {
        if (name == null) {
            return null;
        }
        String[] split = name.split("[.]");
        StringBuilder packageString = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            String s = JavaUtils.removeJavaNameUnwantedCharacters(split[i]);
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            packageString.append(s.toLowerCase());
            if (i >= split.length - 1) continue;
            packageString.append(".");
        }
        return packageString.toString();
    }

    public static boolean isReservedJavaWord(String word) {
        return reservedJavaWords.contains(word);
    }

    public static String abbreviateText(String text, int maxLength) {
        if (StringUtils.isBlank((CharSequence)text) || text.length() <= maxLength) {
            return text;
        }
        String firstText = StringUtils.substring((String)text, (int)0, (int)maxLength);
        int lastIndexOfWithDot = firstText.lastIndexOf(".");
        return lastIndexOfWithDot == -1 ? StringUtils.abbreviate((String)text, (int)maxLength) : StringUtils.substring((String)firstText, (int)0, (int)(lastIndexOfWithDot + 1));
    }

    public static String abbreviateText(String text) {
        return JavaUtils.abbreviateText(text, 128);
    }
}

