/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.security;

import org.mule.connectivity.restconnect.internal.connectormodel.parameter.Parameter;

import java.util.List;

public class OAuth2AuthorizationCodeScheme extends OAuth2Scheme {

  public OAuth2AuthorizationCodeScheme(String displayName, String authorizationUri, String accessTokenUri, List<String> scopes,
                                       List<Parameter> queryParameters, List<Parameter> headers,
                                       TestConnectionConfig testConnectionConfig) {
    super(displayName, GrantType.AUTHORIZATION_CODE, authorizationUri, accessTokenUri, scopes, queryParameters, headers,
          testConnectionConfig);
  }
}
