/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.model;

/**
 * Descriptor element that allows defining a validation to be done over the connection validation request.
 */
public class TestConnectionResponseValidationDescriptor {

  private ExpressionDescriptor validationExpression;
  private ExpressionDescriptor errorTemplateExpression;

  public TestConnectionResponseValidationDescriptor(
                                                    ExpressionDescriptor validationExpression,
                                                    ExpressionDescriptor errorTemplateExpression) {
    this.validationExpression = validationExpression;
    this.errorTemplateExpression = errorTemplateExpression;
  }

  public ExpressionDescriptor getValidationExpression() {
    return validationExpression;
  }

  public ExpressionDescriptor getErrorTemplateExpression() {
    return errorTemplateExpression;
  }
}
