/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.document.DialectInstance;
import amf.client.model.domain.DialectDomainElement;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.PaginationDeclarationDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.SecuritySchemeDescriptor;
import org.mule.connectivity.restconnect.internal.util.AMFWrapper;

import java.io.File;
import java.util.List;

import static org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorPaginationParser.parsePaginationsDescription;


public final class DescriptorParser {

  private DescriptorBaseUriParser descriptorBaseUriParser = new DescriptorBaseUriParser();
  private DescriptorEndpointParser descriptorEndpointParser = new DescriptorEndpointParser();
  private DescriptorApiSpecParser descriptorApiSpecParser = new DescriptorApiSpecParser();
  private DescriptorMavenGavParser descriptorMavenGavParser = new DescriptorMavenGavParser();
  private DescriptorEncodesParser descriptorEncodesParser = new DescriptorEncodesParser();
  private DescriptorSecurityParser descriptorSecurityParser = new DescriptorSecurityParser();
  private DescriptorTestConnectionParser descriptorTestConnectionParser = new DescriptorTestConnectionParser();

  public ConnectorDescriptor parseConnectorDescriptor(File connectorDescriptor)
      throws ModelGenerationException {
    DialectInstance dialectInstance = AMFWrapper.parseConnectorDescriptor(connectorDescriptor);
    DialectDomainElement encodes = dialectInstance.encodes();

    return new ConnectorDescriptor(descriptorApiSpecParser.parseApiSpec(encodes),
                                   parseConnectorName(encodes),
                                   parseConnectorDescription(encodes),
                                   descriptorMavenGavParser
                                       .parseMavenGav(descriptorMavenGavParser.parseConnectorGavElement(encodes)),
                                   descriptorBaseUriParser.parseBaseUri(encodes),
                                   descriptorEndpointParser.parseEndpoints(encodes, connectorDescriptor.toPath()),
                                   parsePaginations(encodes),
                                   parseSecurity(encodes),
                                   parseConnectorCategory(encodes),
                                   parseBaseJavaPackage(encodes),
                                   parseExtensionXml(encodes),
                                   parseSkipOutputTypeValidation(encodes),
                                   parseDefaultInputMediaType(encodes),
                                   parseDefaultOutputMediaType(encodes),
                                   parseQueryParamArrayFormat(encodes),
                                   descriptorTestConnectionParser.parseTestConnection(encodes));
  }

  private String parseQueryParamArrayFormat(DialectDomainElement encodes) {
    return descriptorEncodesParser.parseQueryParamArrayFormat(encodes);
  }

  private String parseDefaultOutputMediaType(DialectDomainElement encodes) {
    return descriptorEncodesParser.parseDefaultOutputMediaType(encodes);
  }

  private String parseDefaultInputMediaType(DialectDomainElement encodes) {
    return descriptorEncodesParser.parseDefaultInputMediaType(encodes);
  }

  private Boolean parseSkipOutputTypeValidation(DialectDomainElement encodes) {
    return descriptorEncodesParser.parseSkipOutputTypeValidation(encodes);
  }

  private String parseExtensionXml(DialectDomainElement encodes) {
    return descriptorEncodesParser.parseExtensionXml(encodes);
  }

  private String parseBaseJavaPackage(DialectDomainElement encodes) {
    return descriptorEncodesParser.parseJavaPackage(encodes);
  }

  private String parseConnectorCategory(DialectDomainElement encodes) {
    return descriptorEncodesParser.parseConnectorCategory(encodes);
  }

  private List<SecuritySchemeDescriptor> parseSecurity(DialectDomainElement encodes) {
    return descriptorSecurityParser.parseSecurityScheme(encodes);
  }

  private static List<PaginationDeclarationDescriptor> parsePaginations(DialectDomainElement encodes) {
    return parsePaginationsDescription(encodes);
  }

  private String parseConnectorDescription(DialectDomainElement encodes) {
    return DescriptorParserUtils.parseElementCoreDescription(encodes);
  }

  private String parseConnectorName(DialectDomainElement encodes) {
    return DescriptorParserUtils.parseElementCoreName(encodes);
  }

}
