/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import static java.nio.charset.StandardCharsets.UTF_8;
import static org.apache.commons.lang3.StringUtils.isBlank;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;

import amf.client.model.domain.DialectDomainElement;

public final class DescriptorParserUtils {

  private static final String CORE_NAME = "http://a.ml/vocabularies.restc/core#name";
  private static final String CORE_DESCRIPTION = "http://a.ml/vocabularies.restc/core#description";
  private static final String REST_CONNECT_IGNORE = "http://a.ml/vocabularies/restConnect#ignore";
  private static final String REST_CONNECT_BASE_URI_REFERENCE = "http://a.ml/vocabularies/restConnect#baseUriReference";

  private DescriptorParserUtils() {}

  public static boolean parseRestConnectIgnored(DialectDomainElement element) {
    List<Object> ignores = element.getScalarByPropertyUri(REST_CONNECT_IGNORE);
    return !ignores.isEmpty() && Boolean.parseBoolean(ignores.get(0).toString());
  }

  public static String parseAlternativeBaseUri(DialectDomainElement element) {
    List<Object> urls = element.getScalarByPropertyUri(REST_CONNECT_BASE_URI_REFERENCE);
    return urls.isEmpty() ? null : urls.get(0).toString();
  }

  public static String parseElementCoreName(DialectDomainElement element) {
    List<Object> elementNames = element.getScalarByPropertyUri(CORE_NAME);
    return elementNames.isEmpty() ? null : elementNames.get(0).toString();
  }

  public static String parseElementCoreDescription(DialectDomainElement element) {
    List<Object> elementDescriptions = element.getScalarByPropertyUri(CORE_DESCRIPTION);
    return elementDescriptions.isEmpty() ? null : elementDescriptions.get(0).toString();
  }

  public static String getSchemaContent(Path descriptorDirectory, String inputSchemaPathString) throws ModelGenerationException {
    if (isBlank(inputSchemaPathString)) {
      return null;
    }
    Path schemaPath = descriptorDirectory.resolve(inputSchemaPathString);

    try {
      byte[] encoded = Files.readAllBytes(schemaPath);
      return new String(encoded, UTF_8);
    } catch (IOException e) {
      throw new ModelGenerationException("Could not read schema file: " + schemaPath, e);
    }
  }

}
